<?php
require_once dirname(__DIR__) . '/config.php';
inc('includes/seo.php');

$pageTitle = optimize_title('Privacy Policy | GHL Toolset');
$pageDescription = optimize_description('Our privacy policy explains how we collect, use, and protect your personal information when using our free GoHighLevel tools.');
$canonicalUrl = get_canonical_url('legal/privacy');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <?php 
    render_meta($pageTitle, $pageDescription, $canonicalUrl);
    render_preconnects();
    ?>
    
    <link rel="stylesheet" href="../public/css/tokens.css">
    <link rel="stylesheet" href="../styles.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <script>
        window.GA4_ID = '<?php echo GA4_ID; ?>';
        window.ADSENSE_PUB = '<?php echo ADSENSE_PUB; ?>';
    </script>
</head>
<body>
    <a href="#main-content" class="skip-to-content">Skip to content</a>
    
    <?php inc('includes/header.php'); ?>
    
    <main id="main-content">
        <div class="legal-page">
            <div class="container">
                <div class="legal-content">
                    <h1>Privacy Policy</h1>
                    
                    <div class="last-updated">
                        <p><strong>Last Updated:</strong> January 12, 2025</p>
                    </div>
                    
                    <section class="legal-section">
                        <h2>1. Introduction</h2>
                        <p>GHL Toolset ("we," "our," or "us") is committed to protecting your privacy. This Privacy Policy explains how we collect, use, disclose, and safeguard your information when you visit our website and use our free GoHighLevel tools.</p>
                        
                        <p>By using our website, you consent to the data practices described in this statement. If you do not agree with the terms of this Privacy Policy, please do not access or use our website.</p>
                    </section>
                    
                    <section class="legal-section">
                        <h2>2. Information We Collect</h2>
                        
                        <h3>2.1 Information You Provide</h3>
                        <ul>
                            <li><strong>Contact Information:</strong> When you request an audit or contact us, we may collect your name, email address, company name, and other information you voluntarily provide.</li>
                            <li><strong>Tool Usage Data:</strong> Information you enter into our tools for calculations and analysis. This data is processed locally in your browser and is not stored on our servers unless explicitly stated.</li>
                            <li><strong>Communication Data:</strong> Records of your communications with us, including emails and support requests.</li>
                        </ul>
                        
                        <h3>2.2 Information Automatically Collected</h3>
                        <ul>
                            <li><strong>Analytics Data:</strong> With your consent, we use Google Analytics to collect information about how you use our website, including pages visited, time spent, and user interactions.</li>
                            <li><strong>Technical Information:</strong> IP address, browser type, device information, operating system, and referring website.</li>
                            <li><strong>Cookies and Tracking:</strong> We use cookies and similar technologies to enhance your experience and analyze website usage.</li>
                        </ul>
                    </section>
                    
                    <section class="legal-section">
                        <h2>3. How We Use Your Information</h2>
                        <p>We use the information we collect for the following purposes:</p>
                        <ul>
                            <li>Provide and maintain our free tools and services</li>
                            <li>Respond to your inquiries and provide customer support</li>
                            <li>Send you information about our services (with your consent)</li>
                            <li>Analyze website usage to improve our tools and user experience</li>
                            <li>Comply with legal obligations and protect our rights</li>
                            <li>Prevent fraud and ensure website security</li>
                        </ul>
                    </section>
                    
                    <section class="legal-section">
                        <h2>4. Cookies and Tracking Technologies</h2>
                        
                        <h3>4.1 Types of Cookies We Use</h3>
                        <ul>
                            <li><strong>Necessary Cookies:</strong> Essential for the website to function properly. These cannot be disabled.</li>
                            <li><strong>Analytics Cookies:</strong> Help us understand how visitors interact with our website (requires consent).</li>
                            <li><strong>Advertising Cookies:</strong> Used to deliver relevant advertisements and measure ad performance (requires consent).</li>
                            <li><strong>Preference Cookies:</strong> Remember your settings and preferences (requires consent).</li>
                        </ul>
                        
                        <h3>4.2 Managing Cookies</h3>
                        <p>You can control cookies through our consent banner and your browser settings. Note that disabling certain cookies may affect website functionality.</p>
                    </section>
                    
                    <section class="legal-section">
                        <h2>5. Third-Party Services</h2>
                        
                        <h3>5.1 Google Analytics</h3>
                        <p>We use Google Analytics to analyze website traffic and user behavior. Google Analytics may collect information such as your IP address, browser type, and pages visited. This data is used to improve our website and services.</p>
                        
                        <h3>5.2 Google AdSense</h3>
                        <p>We use Google AdSense to display advertisements. AdSense may use cookies to serve ads based on your interests and previous visits to our site and other websites.</p>
                        
                        <h3>5.3 Affiliate Partners</h3>
                        <p>We may recommend third-party services and products. When you click on affiliate links, the respective companies may collect information about your visit. These companies have their own privacy policies.</p>
                        
                        <h3>5.4 Paddle CRM</h3>
                        <p>When you request an audit, we may redirect you to Paddle CRM for booking. Paddle CRM has its own privacy policy governing the collection and use of your information.</p>
                    </section>
                    
                    <section class="legal-section">
                        <h2>6. Data Security</h2>
                        <p>We implement appropriate technical and organizational security measures to protect your personal information against unauthorized access, alteration, disclosure, or destruction. However, no method of transmission over the internet is 100% secure.</p>
                        
                        <ul>
                            <li>SSL encryption for data transmission</li>
                            <li>Regular security updates and monitoring</li>
                            <li>Limited access to personal information</li>
                            <li>Secure hosting and data storage</li>
                        </ul>
                    </section>
                    
                    <section class="legal-section">
                        <h2>7. Data Retention</h2>
                        <p>We retain personal information only for as long as necessary to fulfill the purposes outlined in this Privacy Policy, unless a longer retention period is required by law.</p>
                        
                        <ul>
                            <li><strong>Contact Information:</strong> Retained until you request deletion or unsubscribe</li>
                            <li><strong>Analytics Data:</strong> Automatically deleted after 26 months</li>
                            <li><strong>Cookies:</strong> Expire according to their individual settings</li>
                        </ul>
                    </section>
                    
                    <section class="legal-section">
                        <h2>8. Your Rights</h2>
                        <p>Depending on your location, you may have the following rights regarding your personal information:</p>
                        
                        <ul>
                            <li><strong>Access:</strong> Request a copy of the personal information we hold about you</li>
                            <li><strong>Correction:</strong> Request correction of inaccurate or incomplete information</li>
                            <li><strong>Deletion:</strong> Request deletion of your personal information</li>
                            <li><strong>Portability:</strong> Request transfer of your data to another service</li>
                            <li><strong>Objection:</strong> Object to processing of your personal information</li>
                            <li><strong>Withdrawal of Consent:</strong> Withdraw consent for data processing</li>
                        </ul>
                        
                        <p>To exercise these rights, please contact us using the information provided below.</p>
                    </section>
                    
                    <section class="legal-section">
                        <h2>9. International Data Transfers</h2>
                        <p>Your information may be transferred to and processed in countries other than your own. We ensure appropriate safeguards are in place to protect your personal information in accordance with applicable laws.</p>
                    </section>
                    
                    <section class="legal-section">
                        <h2>10. Children's Privacy</h2>
                        <p>Our website is not intended for children under 13 years of age. We do not knowingly collect personal information from children under 13. If we become aware that we have collected personal information from a child under 13, we will delete such information.</p>
                    </section>
                    
                    <section class="legal-section">
                        <h2>11. Changes to This Privacy Policy</h2>
                        <p>We may update this Privacy Policy from time to time. We will notify you of any changes by posting the new Privacy Policy on this page and updating the "Last Updated" date. Continued use of our website after changes constitutes acceptance of the updated policy.</p>
                    </section>
                    
                    <section class="legal-section">
                        <h2>12. Contact Information</h2>
                        <p>If you have any questions about this Privacy Policy or our data practices, please contact us:</p>
                        
                        <div class="contact-info">
                            <p><strong>Email:</strong> privacy@ghl-toolset.com</p>
                            <p><strong>Website:</strong> <a href="<?php echo BASE_URL; ?>"><?php echo BASE_URL; ?></a></p>
                        </div>
                        
                        <p>We will respond to your inquiry within 30 days.</p>
                    </section>
                </div>
            </div>
        </div>
    </main>
    
    <?php inc('includes/footer.php'); ?>
    
    <script src="../lib/js/consent.js"></script>
    <script src="../lib/js/analytics.js"></script>
    
    <style>
        .legal-page {
            padding: var(--space-16) 0;
            background: var(--color-neutral-50);
        }
        
        .legal-content {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            padding: var(--space-12);
            border-radius: var(--radius-xl);
            box-shadow: var(--shadow-base);
        }
        
        .legal-content h1 {
            font-size: var(--font-size-4xl);
            color: var(--color-neutral-900);
            margin-bottom: var(--space-8);
            text-align: center;
        }
        
        .last-updated {
            text-align: center;
            margin-bottom: var(--space-12);
            padding: var(--space-4);
            background: var(--color-neutral-100);
            border-radius: var(--radius-base);
        }
        
        .legal-section {
            margin-bottom: var(--space-12);
        }
        
        .legal-section h2 {
            font-size: var(--font-size-2xl);
            color: var(--color-neutral-900);
            margin-bottom: var(--space-6);
            border-bottom: 2px solid var(--color-primary-100);
            padding-bottom: var(--space-2);
        }
        
        .legal-section h3 {
            font-size: var(--font-size-xl);
            color: var(--color-neutral-800);
            margin: var(--space-6) 0 var(--space-4) 0;
        }
        
        .legal-section p {
            margin-bottom: var(--space-4);
            line-height: var(--line-height-relaxed);
            color: var(--color-neutral-700);
        }
        
        .legal-section ul {
            margin: var(--space-4) 0;
            padding-left: var(--space-6);
        }
        
        .legal-section li {
            margin-bottom: var(--space-2);
            line-height: var(--line-height-relaxed);
            color: var(--color-neutral-700);
        }
        
        .contact-info {
            background: var(--color-primary-50);
            padding: var(--space-6);
            border-radius: var(--radius-base);
            margin: var(--space-4) 0;
        }
        
        .contact-info p {
            margin-bottom: var(--space-2);
            font-weight: var(--font-weight-medium);
        }
        
        .contact-info a {
            color: var(--color-primary-600);
            text-decoration: none;
        }
        
        .contact-info a:hover {
            text-decoration: underline;
        }
    </style>
</body>
</html>