﻿<?php
require_once __DIR__ . '/config.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>GHL Tools - Free GoHighLevel Toolset for Agencies & Users | Paddle CRM</title>
    <meta name="description" content="Free professional tools for GoHighLevel users and agencies. SMS counter, ROI calculator, lead scoring, SEO tools, and more. Boost your GHL workflow today!">
    <meta name="keywords" content="GoHighLevel tools, GHL toolkit, CRM tools, SMS counter, ROI calculator, lead scoring, email optimization, funnel calculator, UTM builder, GoHighLevel agency tools, free CRM tools">
    <meta name="author" content="Paddle CRM">
    <meta name="robots" content="index, follow">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:title" content="GHL Tools - Free GoHighLevel Toolset for Agencies & Users">
    <meta property="og:description" content="Free professional tools for GoHighLevel users and agencies. SMS counter, ROI calculator, lead scoring, SEO tools, and more.">
    <meta property="og:url" content="https://yourdomain.com">
    <meta property="og:image" content="https://yourdomain.com/images/ghl-tools-og.jpg">
    <meta property="og:site_name" content="GHL Tools by Paddle CRM">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:title" content="GHL Tools - Free GoHighLevel Toolset">
    <meta property="twitter:description" content="Free professional tools for GoHighLevel users and agencies. Boost your GHL workflow today!">
    <meta property="twitter:image" content="https://yourdomain.com/images/ghl-tools-twitter.jpg">

    <!-- Structured Data -->
    <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@type": "WebApplication",
      "name": "GHL Tools - Free GoHighLevel Toolset",
      "description": "Collection of free professional tools for GoHighLevel users including SMS counter, ROI calculator, lead scoring, SEO tools, and more",
      "url": "https://yourdomain.com",
      "applicationCategory": "BusinessApplication",
      "operatingSystem": "Web Browser",
      "offers": {
        "@type": "Offer",
        "price": "0",
        "priceCurrency": "USD"
      },
      "provider": {
        "@type": "Organization",
        "name": "Paddle CRM",
        "description": "WhiteLabel GoHighLevel Agency"
      }
    }
    </script>

    <link rel="stylesheet" href="styles.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
<?php inc('includes/header.php'); ?>

    <!-- Hero Section -->
    <section class="hero">
        <div class="container">
            <div class="hero-content">
                <div class="hero-text">
                    <h1 class="hero-title">
                        Free Professional Tools for 
                        <span class="highlight">GoHighLevel</span> Users
                    </h1>
                    <p class="hero-subtitle">
                        Supercharge your GHL workflow with our comprehensive toolkit. SMS optimization, 
                        lead scoring, ROI analysis, SEO tools, and more - all completely free.
                    </p>
                    <div class="hero-stats">
                        <div class="stat-item">
                            <span class="stat-number">20+</span>
                            <span class="stat-label">Free Tools</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number">10K+</span>
                            <span class="stat-label">Active Users</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number">100%</span>
                            <span class="stat-label">Free Forever</span>
                        </div>
                    </div>
                    <div class="hero-actions">
                        <a href="#tools" class="btn btn-primary">Explore All Tools</a>
                        <a href="#newsletter" class="btn btn-secondary">Get Weekly Updates</a>
                    </div>
                </div>
                <div class="hero-visual">
                    <div class="hero-image">
                        <div class="floating-card card-1">
                            <span class="card-icon">📱</span>
                            <span class="card-text">SMS Counter</span>
                        </div>
                        <div class="floating-card card-2">
                            <span class="card-icon">💰</span>
                            <span class="card-text">ROI Calculator</span>
                        </div>
                        <div class="floating-card card-3">
                            <span class="card-icon">⭐</span>
                            <span class="card-text">Lead Scoring</span>
                        </div>
                        <div class="floating-card card-4">
                            <span class="card-icon">🔍</span>
                            <span class="card-text">SEO Tools</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Trust Indicators -->
    <section class="trust-section">
        <div class="container">
            <div class="trust-grid">
                <div class="trust-item">
                    <div class="trust-icon">🔒</div>
                    <h3>100% Free</h3>
                    <p>No hidden costs, no premium tiers, no credit card required</p>
                </div>
                <div class="trust-item">
                    <div class="trust-icon">⚡</div>
                    <h3>Instant Access</h3>
                    <p>Use any tool immediately - no registration or downloads needed</p>
                </div>
                <div class="trust-item">
                    <div class="trust-icon">🎯</div>
                    <h3>GHL Optimized</h3>
                    <p>Built specifically for GoHighLevel workflows and best practices</p>
                </div>
                <div class="trust-item">
                    <div class="trust-icon">🚀</div>
                    <h3>Professional Grade</h3>
                    <p>Enterprise-level tools used by top GHL agencies worldwide</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Tools Overview Section -->
    <section id="tools" class="tools-section">
        <div class="container">
            <div class="section-header">
                <h2>Complete GoHighLevel Toolset</h2>
                <p>Everything you need to optimize your GHL campaigns, funnels, and client results</p>
            </div>

            <!-- Marketing & Analytics Tools -->
            <div class="tools-category">
                <h3>📊 Marketing & Analytics Tools</h3>
                <div class="tools-grid">
                    <a href="sms-counter.php" class="tool-card">
                        <div class="tool-icon">📱</div>
                        <h4>SMS Character Counter & Cost Calculator</h4>
                        <p>Count characters, estimate SMS segments, and calculate costs for your GoHighLevel campaigns</p>
                        <div class="tool-features">
                            <span class="feature-tag">Character Count</span>
                            <span class="feature-tag">Cost Estimation</span>
                            <span class="feature-tag">Segment Analysis</span>
                        </div>
                        <div class="tool-cta">
                            <span class="cta-text">Use Tool</span>
                            <span class="cta-arrow">→</span>
                        </div>
                    </a>

                    <a href="roi-calculator.php" class="tool-card">
                        <div class="tool-icon">💰</div>
                        <h4>Funnel ROI Calculator</h4>
                        <p>Calculate return on investment for your GoHighLevel funnels with detailed revenue projections</p>
                        <div class="tool-features">
                            <span class="feature-tag">ROI Analysis</span>
                            <span class="feature-tag">Revenue Forecasting</span>
                            <span class="feature-tag">Performance Metrics</span>
                        </div>
                        <div class="tool-cta">
                            <span class="cta-text">Use Tool</span>
                            <span class="cta-arrow">→</span>
                        </div>
                    </a>

                    <a href="lead-scoring.php" class="tool-card">
                        <div class="tool-icon">⭐</div>
                        <h4>Lead Scoring Calculator</h4>
                        <p>Score leads based on engagement patterns and behavior to prioritize your sales efforts</p>
                        <div class="tool-features">
                            <span class="feature-tag">Engagement Scoring</span>
                            <span class="feature-tag">Behavior Analysis</span>
                            <span class="feature-tag">Priority Ranking</span>
                        </div>
                        <div class="tool-cta">
                            <span class="cta-text">Use Tool</span>
                            <span class="cta-arrow">→</span>
                        </div>
                    </a>

                    <a href="funnel-calculator.php" class="tool-card">
                        <div class="tool-icon">📊</div>
                        <h4>Funnel Performance Calculator</h4>
                        <p>Analyze your sales funnel performance and identify optimization opportunities</p>
                        <div class="tool-features">
                            <span class="feature-tag">Conversion Analysis</span>
                            <span class="feature-tag">Bottleneck Detection</span>
                            <span class="feature-tag">Revenue Projections</span>
                        </div>
                        <div class="tool-cta">
                            <span class="cta-text">Use Tool</span>
                            <span class="cta-arrow">→</span>
                        </div>
                    </a>

                    <a href="utm-builder.php" class="tool-card">
                        <div class="tool-icon">🔗</div>
                        <h4>UTM Parameter Builder</h4>
                        <p>Build trackable URLs for your marketing campaigns with proper UTM parameters</p>
                        <div class="tool-features">
                            <span class="feature-tag">Campaign Tracking</span>
                            <span class="feature-tag">URL Generation</span>
                            <span class="feature-tag">Analytics Setup</span>
                        </div>
                        <div class="tool-cta">
                            <span class="cta-text">Use Tool</span>
                            <span class="cta-arrow">→</span>
                        </div>
                    </a>

                    <a href="ab-testing.php" class="tool-card">
                        <div class="tool-icon">🧪</div>
                        <h4>A/B Test Significance Calculator</h4>
                        <p>Determine if your A/B test results are statistically significant for confident decision-making</p>
                        <div class="tool-features">
                            <span class="feature-tag">Statistical Analysis</span>
                            <span class="feature-tag">Confidence Testing</span>
                            <span class="feature-tag">Result Validation</span>
                        </div>
                        <div class="tool-cta">
                            <span class="cta-text">Use Tool</span>
                            <span class="cta-arrow">→</span>
                        </div>
                    </a>
                </div>
            </div>

            <!-- Content & SEO Tools -->
            <div class="tools-category">
                <h3>🔍 Content & SEO Tools</h3>
                <div class="tools-grid">
                    <a href="meta-tag-generator.php" class="tool-card">
                        <div class="tool-icon">🏷️</div>
                        <h4>Meta Tag Generator</h4>
                        <p>Generate SEO-optimized meta tags, Open Graph tags, and Twitter cards for your web pages</p>
                        <div class="tool-features">
                            <span class="feature-tag">SEO Optimization</span>
                            <span class="feature-tag">Social Media</span>
                            <span class="feature-tag">Preview Generation</span>
                        </div>
                        <div class="tool-cta">
                            <span class="cta-text">Use Tool</span>
                            <span class="cta-arrow">→</span>
                        </div>
                    </a>

                    <a href="keyword-density-checker.php" class="tool-card">
                        <div class="tool-icon">🔍</div>
                        <h4>Keyword Density Checker</h4>
                        <p>Analyze keyword density in your content for optimal SEO performance</p>
                        <div class="tool-features">
                            <span class="feature-tag">Keyword Analysis</span>
                            <span class="feature-tag">SEO Optimization</span>
                            <span class="feature-tag">Content Review</span>
                        </div>
                        <div class="tool-cta">
                            <span class="cta-text">Use Tool</span>
                            <span class="cta-arrow">→</span>
                        </div>
                    </a>

                    <a href="content-readability-scorer.php" class="tool-card">
                        <div class="tool-icon">📖</div>
                        <h4>Content Readability Scorer</h4>
                        <p>Analyze and improve the readability of your content for better user engagement</p>
                        <div class="tool-features">
                            <span class="feature-tag">Readability Score</span>
                            <span class="feature-tag">Content Analysis</span>
                            <span class="feature-tag">Improvement Tips</span>
                        </div>
                        <div class="tool-cta">
                            <span class="cta-text">Use Tool</span>
                            <span class="cta-arrow">→</span>
                        </div>
                    </a>
                </div>
            </div>

            <!-- Security & Utility Tools -->
            <div class="tools-category">
                <h3>🔐 Security & Utility Tools</h3>
                <div class="tools-grid">
                    <a href="password-generator.php" class="tool-card">
                        <div class="tool-icon">🔒</div>
                        <h4>Secure Password Generator</h4>
                        <p>Generate strong, secure passwords for your GoHighLevel accounts and client portals</p>
                        <div class="tool-features">
                            <span class="feature-tag">Strong Passwords</span>
                            <span class="feature-tag">Customizable</span>
                            <span class="feature-tag">Security Focused</span>
                        </div>
                        <div class="tool-cta">
                            <span class="cta-text">Use Tool</span>
                            <span class="cta-arrow">→</span>
                        </div>
                    </a>

                    <a href="hash-generator.php" class="tool-card">
                        <div class="tool-icon">🔐</div>
                        <h4>Hash Generator</h4>
                        <p>Generate MD5, SHA-1, SHA-256, and other hash algorithms for data security and verification</p>
                        <div class="tool-features">
                            <span class="feature-tag">Multiple Algorithms</span>
                            <span class="feature-tag">Data Security</span>
                            <span class="feature-tag">Verification Tools</span>
                        </div>
                        <div class="tool-cta">
                            <span class="cta-text">Use Tool</span>
                            <span class="cta-arrow">→</span>
                        </div>
                    </a>

                    <a href="base64-encoder-decoder.php" class="tool-card">
                        <div class="tool-icon">🔄</div>
                        <h4>Base64 Encoder/Decoder</h4>
                        <p>Encode and decode Base64 strings for data transmission and API integrations</p>
                        <div class="tool-features">
                            <span class="feature-tag">Encoding/Decoding</span>
                            <span class="feature-tag">API Support</span>
                            <span class="feature-tag">Data Conversion</span>
                        </div>
                        <div class="tool-cta">
                            <span class="cta-text">Use Tool</span>
                            <span class="cta-arrow">→</span>
                        </div>
                    </a>

                    <a href="json-formatter-validator.php" class="tool-card">
                        <div class="tool-icon">📋</div>
                        <h4>JSON Formatter & Validator</h4>
                        <p>Format, validate, and optimize JSON data for your API integrations and web applications</p>
                        <div class="tool-features">
                            <span class="feature-tag">JSON Formatting</span>
                            <span class="feature-tag">Validation</span>
                            <span class="feature-tag">API Support</span>
                        </div>
                        <div class="tool-cta">
                            <span class="cta-text">Use Tool</span>
                            <span class="cta-arrow">→</span>
                        </div>
                    </a>
                </div>
            </div>

            <!-- Email & Communication Tools -->
            <div class="tools-category">
                <h3>📧 Email & Communication Tools</h3>
                <div class="tools-grid">
                    <a href="email-subject-line-scorer.php" class="tool-card">
                        <div class="tool-icon">📧</div>
                        <h4>Email Subject Line Scorer</h4>
                        <p>Analyze and score your email subject lines for better open rates and engagement</p>
                        <div class="tool-features">
                            <span class="feature-tag">Subject Analysis</span>
                            <span class="feature-tag">Open Rate Optimization</span>
                            <span class="feature-tag">Engagement Tips</span>
                        </div>
                        <div class="tool-cta">
                            <span class="cta-text">Use Tool</span>
                            <span class="cta-arrow">→</span>
                        </div>
                    </a>

                    <a href="email-deliverability-checker.php" class="tool-card">
                        <div class="tool-icon">✉️</div>
                        <h4>Email Deliverability Checker</h4>
                        <p>Analyze your email content for spam triggers and deliverability issues</p>
                        <div class="tool-features">
                            <span class="feature-tag">Spam Detection</span>
                            <span class="feature-tag">Deliverability Analysis</span>
                            <span class="feature-tag">Best Practices</span>
                        </div>
                        <div class="tool-cta">
                            <span class="cta-text">Use Tool</span>
                            <span class="cta-arrow">→</span>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Why Choose GHL Tools Section -->
    <section class="why-section">
        <div class="container">
            <div class="section-header">
                <h2>Why Agencies Choose GHL Tools</h2>
                <p>Built by GoHighLevel experts, for GoHighLevel experts</p>
            </div>
            
            <div class="why-grid">
                <div class="why-item">
                    <div class="why-icon">🎯</div>
                    <h3>Purpose-Built for GHL</h3>
                    <p>Every tool is designed specifically for GoHighLevel workflows, terminology, and best practices</p>
                </div>
                <div class="why-item">
                    <div class="why-icon">⚡</div>
                    <h3>Instant Results</h3>
                    <p>No learning curve - use tools immediately to improve client campaigns and results</p>
                </div>
                <div class="why-item">
                    <div class="why-icon">🔒</div>
                    <h3>Client-Ready</h3>
                    <p>Professional tools you can confidently use with clients to demonstrate expertise</p>
                </div>
                <div class="why-item">
                    <div class="why-icon">📈</div>
                    <h3>Performance Focused</h3>
                    <p>Every tool is designed to improve measurable outcomes and ROI for your clients</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Newsletter Section -->
    <section id="newsletter" class="newsletter-section">
        <div class="container">
            <div class="newsletter-content">
                <div class="newsletter-text">
                    <h2>Get Weekly GHL Tool Updates</h2>
                    <p>Join 10,000+ GoHighLevel users getting weekly updates on new tools, strategies, and optimization tips.</p>
                    <ul class="newsletter-benefits">
                        <li>✨ New tool announcements</li>
                        <li>📊 GHL optimization strategies</li>
                        <li>🎯 Agency growth tips</li>
                        <li>🚀 Exclusive early access</li>
                    </ul>
                </div>
                <div class="newsletter-form">
                    <form class="signup-form">
                        <div class="form-group">
                            <input type="email" placeholder="Enter your email address" required>
                            <button type="submit" class="btn btn-primary">Get Free Updates</button>
                        </div>
                        <small>No spam, unsubscribe anytime. We respect your privacy.</small>
                    </form>
                </div>
            </div>
        </div>
    </section>

    <!-- FAQ Section -->
    <section class="faq-section">
        <div class="container">
            <div class="section-header">
                <h2>Frequently Asked Questions</h2>
                <p>Everything you need to know about GHL Tools</p>
            </div>
            
            <div class="faq-grid">
                <div class="faq-item">
                    <h3>Are these tools really free to use?</h3>
                    <p>Yes! All tools are completely free with no hidden costs, premium tiers, or credit card requirements. We're committed to helping the GoHighLevel community succeed.</p>
                </div>
                <div class="faq-item">
                    <h3>Can I use these tools for my clients?</h3>
                    <p>Absolutely! These tools are perfect for agencies managing multiple GoHighLevel accounts. Use them to optimize client campaigns and demonstrate technical expertise.</p>
                </div>
                <div class="faq-item">
                    <h3>How often do you add new tools?</h3>
                    <p>We regularly add new tools based on user feedback and emerging GoHighLevel needs. Subscribe to our newsletter to stay updated on new releases.</p>
                </div>
                <div class="faq-item">
                    <h3>Do I need to create an account?</h3>
                    <p>No account creation required! Use any tool immediately - no registration, downloads, or setup needed.</p>
                </div>
                <div class="faq-item">
                    <h3>Are these tools optimized for mobile?</h3>
                    <p>Yes! All tools are fully responsive and work perfectly on desktop, tablet, and mobile devices.</p>
                </div>
                <div class="faq-item">
                    <h3>Can I suggest new tool ideas?</h3>
                    <p>Absolutely! We love hearing from users about what tools would be most helpful. Contact us with your suggestions.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Resources Section -->
    <section id="resources" class="resources-section">
        <div class="container">
            <div class="section-header">
                <h2>GoHighLevel Resources & Guides</h2>
                <p>Essential knowledge and strategies to help you succeed with GoHighLevel</p>
            </div>
            
            <div class="resources-grid">
                <article class="resource-card">
                    <div class="resource-icon">📱</div>
                    <h3>Complete Guide to GoHighLevel SMS Marketing</h3>
                    <p>Learn how to create effective SMS campaigns, optimize delivery times, and maximize engagement rates for better conversion results.</p>
                    <div class="resource-features">
                        <span class="feature-tag">SMS Best Practices</span>
                        <span class="feature-tag">Delivery Optimization</span>
                        <span class="feature-tag">Engagement Strategies</span>
                    </div>
                    <a href="#" class="btn btn-secondary">Read Guide</a>
                </article>
                
                <article class="resource-card">
                    <div class="resource-icon">📊</div>
                    <h3>GoHighLevel Funnel Optimization Strategies</h3>
                    <p>Discover proven strategies to improve your funnel conversion rates, reduce drop-offs, and maximize ROI from your marketing campaigns.</p>
                    <div class="resource-features">
                        <span class="feature-tag">Conversion Optimization</span>
                        <span class="feature-tag">Funnel Analysis</span>
                        <span class="feature-tag">ROI Maximization</span>
                    </div>
                    <a href="#" class="btn btn-secondary">Read Guide</a>
                </article>
                
                <article class="resource-card">
                    <div class="resource-icon">🏢</div>
                    <h3>GoHighLevel Agency Best Practices</h3>
                    <p>Essential tips for agencies managing multiple GoHighLevel client accounts efficiently, including workflow automation and reporting strategies.</p>
                    <div class="resource-features">
                        <span class="feature-tag">Agency Management</span>
                        <span class="feature-tag">Workflow Automation</span>
                        <span class="feature-tag">Client Reporting</span>
                    </div>
                    <a href="#" class="btn btn-secondary">Read Guide</a>
                </article>
                
                <article class="resource-card">
                    <div class="resource-icon">🎯</div>
                    <h3>Advanced Lead Scoring for GoHighLevel</h3>
                    <p>Master the art of lead scoring to prioritize your sales efforts and focus on prospects most likely to convert.</p>
                    <div class="resource-features">
                        <span class="feature-tag">Lead Qualification</span>
                        <span class="feature-tag">Scoring Models</span>
                        <span class="feature-tag">Sales Prioritization</span>
                    </div>
                    <a href="#" class="btn btn-secondary">Read Guide</a>
                </article>
                
                <article class="resource-card">
                    <div class="resource-icon">📧</div>
                    <h3>Email Marketing Mastery in GoHighLevel</h3>
                    <p>Learn advanced email marketing techniques including segmentation, automation, and deliverability optimization.</p>
                    <div class="resource-features">
                        <span class="feature-tag">Email Segmentation</span>
                        <span class="feature-tag">Automation Workflows</span>
                        <span class="feature-tag">Deliverability</span>
                    </div>
                    <a href="#" class="btn btn-secondary">Read Guide</a>
                </article>
                
                <article class="resource-card">
                    <div class="resource-icon">🚀</div>
                    <h3>GoHighLevel Workflow Automation Guide</h3>
                    <p>Create powerful automated workflows that nurture leads, follow up with prospects, and close more deals automatically.</p>
                    <div class="resource-features">
                        <span class="feature-tag">Workflow Design</span>
                        <span class="feature-tag">Automation Triggers</span>
                        <span class="feature-tag">Lead Nurturing</span>
                    </div>
                    <a href="#" class="btn btn-secondary">Read Guide</a>
                </article>
            </div>
        </div>
    </section>

    <!-- Contact Section -->
    <section id="contact" class="contact-section">
        <div class="container">
            <div class="section-header">
                <h2>Get in Touch</h2>
                <p>Have questions, suggestions, or need help with GoHighLevel? We'd love to hear from you!</p>
            </div>
            
            <div class="contact-content">
                <div class="contact-info">
                    <div class="contact-item">
                        <div class="contact-icon">💬</div>
                        <h3>Tool Suggestions</h3>
                        <p>Have an idea for a new tool that would help your GoHighLevel workflow? We're always looking for new ideas!</p>
                        <a href="mailto:suggestions@ghltools.com" class="btn btn-secondary">Suggest a Tool</a>
                    </div>
                    
                    <div class="contact-item">
                        <div class="contact-icon">🆘</div>
                        <h3>Support & Help</h3>
                        <p>Need help using any of our tools or have technical questions? Our team is here to help!</p>
                        <a href="mailto:support@ghltools.com" class="btn btn-secondary">Get Support</a>
                    </div>
                    
                    <div class="contact-item">
                        <div class="contact-icon">🤝</div>
                        <h3>Partnership</h3>
                        <p>Interested in partnering with us or have a business opportunity? Let's discuss how we can work together!</p>
                        <a href="mailto:partnerships@ghltools.com" class="btn btn-secondary">Discuss Partnership</a>
                    </div>
                </div>
                
                <div class="contact-form-container">
                    <div class="contact-form">
                        <h3>Send us a Message</h3>
                        <form class="message-form">
                            <div class="form-group">
                                <label for="contactName">Name</label>
                                <input type="text" id="contactName" placeholder="Your name" required>
                            </div>
                            <div class="form-group">
                                <label for="contactEmail">Email</label>
                                <input type="email" id="contactEmail" placeholder="Your email address" required>
                            </div>
                            <div class="form-group">
                                <label for="contactSubject">Subject</label>
                                <select id="contactSubject" required>
                                    <option value="">Select a subject</option>
                                    <option value="tool-suggestion">Tool Suggestion</option>
                                    <option value="support">Support Request</option>
                                    <option value="partnership">Partnership Inquiry</option>
                                    <option value="general">General Question</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="contactMessage">Message</label>
                                <textarea id="contactMessage" rows="5" placeholder="Tell us how we can help..." required></textarea>
                            </div>
                            <button type="submit" class="btn btn-primary">Send Message</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- About Section -->
    <section id="about" class="about-section">
        <div class="container">
            <div class="about-content">
                <div class="about-text">
                    <h2>Built by GoHighLevel Experts</h2>
                    <p>GHL Tools is created by Paddle CRM, a leading WhiteLabel GoHighLevel agency with years of experience helping businesses succeed with the platform.</p>
                    <p>We've built these tools based on real-world challenges we face daily while managing client accounts. Every tool is designed to solve actual problems and improve measurable results.</p>
                    <div class="about-stats">
                        <div class="about-stat">
                            <span class="stat-number">5+</span>
                            <span class="stat-label">Years GHL Experience</span>
                        </div>
                        <div class="about-stat">
                            <span class="stat-number">500+</span>
                            <span class="stat-label">Client Accounts Managed</span>
                        </div>
                        <div class="about-stat">
                            <span class="stat-number">$10M+</span>
                            <span class="stat-label">Revenue Generated</span>
                        </div>
                    </div>
                </div>
                <div class="about-visual">
                    <div class="about-image">
                        <div class="team-avatar">👥</div>
                        <div class="experience-badge">5+ Years</div>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php inc('includes/footer.php'); ?>

    <script src="common.js"></script>
    <script>
        // Mobile Navigation Toggle
        document.getElementById('navToggle').addEventListener('click', function() {
            this.classList.toggle('active');
            document.querySelector('.nav-menu').classList.toggle('active');
        });

        // Smooth Scrolling for Navigation Links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            });
        });

        // Newsletter Form Submission
        document.querySelector('.signup-form').addEventListener('submit', function(e) {
            e.preventDefault();
            const email = this.querySelector('input[type="email"]').value;
            if (email) {
                alert('Thank you for subscribing! You\'ll receive weekly updates on new GHL tools and strategies.');
                this.reset();
            }
        });

        // Contact Form Submission
        document.querySelector('.message-form').addEventListener('submit', function(e) {
            e.preventDefault();
            const name = this.querySelector('#contactName').value;
            const email = this.querySelector('#contactEmail').value;
            const subject = this.querySelector('#contactSubject').value;
            const message = this.querySelector('#contactMessage').value;
            
            if (name && email && subject && message) {
                alert('Thank you for your message! We\'ll get back to you within 24 hours.');
                this.reset();
            } else {
                alert('Please fill in all fields.');
            }
        });

        // Intersection Observer for Animations
        const observerOptions = {
            threshold: 0.1,
            rootMargin: '0px 0px -50px 0px'
        };

        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.classList.add('animate-in');
                }
            });
        }, observerOptions);

        // Observe elements for animation
        document.querySelectorAll('.tool-card, .why-item, .faq-item').forEach(el => {
            observer.observe(el);
        });

        // Floating Card Animation
        function animateFloatingCards() {
            const cards = document.querySelectorAll('.floating-card');
            cards.forEach((card, index) => {
                card.style.animationDelay = `${index * 0.2}s`;
            });
        }

        // Initialize animations
        document.addEventListener('DOMContentLoaded', function() {
            animateFloatingCards();
        });
    </script>
</body>
</html>
