﻿<?php
require_once __DIR__ . '/config.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Email Subject Line Scorer - Free Email Optimization Tool for GoHighLevel Users | GHL Tools</title>
    <meta name="description" content="Score and optimize your email subject lines with our free Email Subject Line Scorer. Perfect for GoHighLevel users to improve open rates and email campaign performance.">
    <meta name="keywords" content="email subject line scorer, email optimization, subject line testing, email open rates, GoHighLevel email marketing, subject line analyzer, email campaign optimization">
    <meta name="author" content="GHL Tools">
    <meta name="robots" content="index, follow">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://ghl-tools.com/email-subject-line-scorer.php">
    <meta property="og:title" content="Email Subject Line Scorer - Free Email Optimization Tool for GoHighLevel Users">
    <meta property="og:description" content="Score and optimize your email subject lines with our free Email Subject Line Scorer. Perfect for GoHighLevel users to improve open rates and email campaign performance.">
    <meta property="og:image" content="https://ghl-tools.com/images/email-subject-line-scorer-og.jpg">
    
    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="https://ghl-tools.com/email-subject-line-scorer.php">
    <meta property="twitter:title" content="Email Subject Line Scorer - Free Email Optimization Tool for GoHighLevel Users">
    <meta property="twitter:description" content="Score and optimize your email subject lines with our free Email Subject Line Scorer. Perfect for GoHighLevel users to improve open rates and email campaign performance.">
    <meta property="twitter:image" content="https://ghl-tools.com/images/email-subject-line-scorer-og.jpg">
    
    <!-- Structured Data -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebApplication",
        "name": "Email Subject Line Scorer",
        "description": "Free tool to score and optimize email subject lines for better open rates and email campaign performance.",
        "url": "https://ghl-tools.com/email-subject-line-scorer.php",
        "applicationCategory": "MarketingApplication",
        "operatingSystem": "Any",
        "offers": {
            "@type": "Offer",
            "price": "0",
            "priceCurrency": "USD"
        },
        "publisher": {
            "@type": "Organization",
            "name": "GHL Tools",
            "url": "https://ghl-tools.com"
        }
    }
    </script>
    
    <link rel="stylesheet" href="styles.css">
    <link rel="canonical" href="https://ghl-tools.com/email-subject-line-scorer.php">
</head>
<body>
    <?php inc('includes/header.php'); ?>

    <!-- Hero Section -->
    <section class="hero tool-hero">
        <div class="container">
            <nav class="breadcrumb">
                <a href="index.php">Home</a> > <span>Email Subject Line Scorer</span>
            </nav>
            <div class="hero-content">
                <div class="hero-text">
                    <h1 class="hero-title">Email Subject Line Scorer</h1>
                    <p class="hero-subtitle">Score and optimize your email subject lines to maximize open rates and campaign performance</p>
                    <div class="hero-stats">
                        <div class="stat-item">
                            <span class="stat-number">Professional</span>
                            <span class="stat-label">Quality</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number">GoHighLevel</span>
                            <span class="stat-label">Optimized</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number">100%</span>
                            <span class="stat-label">Free Tool</span>
                        </div>
                    </div>
                </div>
                <div class="hero-visual">
                    <div class="hero-image">
                        <div class="floating-card card-1">
                            <span class="card-icon">📧</span>
                            <span class="card-text">Subject</span>
                        </div>
                        <div class="floating-card card-2">
                            <span class="card-icon">⚡</span>
                            <span class="card-text">Fast</span>
                        </div>
                        <div class="floating-card card-3">
                            <span class="card-icon">🎯</span>
                            <span class="card-text">Optimized</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Tool Section -->
    <section class="tool-section">
        <div class="container">
            <div class="tool-card featured">
                <div class="tool-header">
                    <div class="tool-icon">📧</div>
                    <h2>Email Subject Line Optimization Tool</h2>
                    <p>Input your email subject line below to get a comprehensive score and optimization recommendations.</p>
                </div>
                
                <div class="tool-interface">
                    <div class="input-group">
                        <label for="subjectLine">Email Subject Line</label>
                        <input type="text" id="subjectLine" placeholder="Enter your email subject line here..." maxlength="100">
                        <small>Character count: <span id="charCount">0</span>/100</small>
                    </div>
                    
                    <div class="input-group">
                        <label for="emailType">Email Type</label>
                        <select id="emailType">
                            <option value="newsletter">Newsletter</option>
                            <option value="promotional">Promotional</option>
                            <option value="transactional">Transactional</option>
                            <option value="nurture">Nurture Sequence</option>
                            <option value="abandoned">Abandoned Cart</option>
                            <option value="welcome">Welcome Series</option>
                        </select>
                    </div>
                    
                    <div class="input-group">
                        <label for="targetAudience">Target Audience</label>
                        <select id="targetAudience">
                            <option value="b2b">B2B</option>
                            <option value="b2c">B2C</option>
                            <option value="agency">Agency</option>
                            <option value="ecommerce">E-commerce</option>
                            <option value="saas">SaaS</option>
                        </select>
                    </div>
                    
                    <button onclick="scoreSubjectLine()" class="btn btn-primary">Score Subject Line</button>
                    
                    <div class="result" id="scoringResult" style="display: none;">
                        <h3>Subject Line Analysis Results</h3>
                        <div id="overallScore"></div>
                        <div id="detailedAnalysis"></div>
                        <div id="optimizationTips"></div>
                        <div id="alternativeSuggestions"></div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Content Sections -->
    <section class="content-section">
        <div class="container">
            <div class="content-grid">
                <article class="content-card">
                    <h2>What is Email Subject Line Scoring?</h2>
                    <p>Email subject line scoring is a systematic approach to evaluating and optimizing email subject lines based on proven best practices, psychological triggers, and industry benchmarks. It helps marketers create subject lines that are more likely to be opened, read, and acted upon.</p>
                    
                    <p>Your email subject line is the first impression recipients have of your message. It's the deciding factor in whether someone opens your email or sends it straight to the trash. A well-scored subject line can dramatically improve your email open rates, click-through rates, and overall campaign performance.</p>
                    
                    <p>Our Email Subject Line Scorer analyzes your subject lines using multiple criteria including:</p>
                    <ul>
                        <li><strong>Length Optimization:</strong> Ideal character count for different email types and platforms</li>
                        <li><strong>Psychological Triggers:</strong> Emotional words, urgency, curiosity, and personalization</li>
                        <li><strong>Spam Filter Avoidance:</strong> Words and phrases that trigger spam filters</li>
                        <li><strong>Mobile Optimization:</strong> How your subject line appears on mobile devices</li>
                        <li><strong>Brand Consistency:</strong> Alignment with your brand voice and messaging</li>
                        <li><strong>Industry Best Practices:</strong> Proven strategies for your specific email type</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Why GoHighLevel Users Need Subject Line Optimization</h2>
                    <p>As a GoHighLevel user, you're managing complex email marketing campaigns, automation sequences, and client communications. Subject line optimization is crucial for:</p>
                    
                    <ul>
                        <li><strong>Campaign Performance:</strong> Improve open rates by 20-50% with optimized subject lines</li>
                        <li><strong>Client Success:</strong> Demonstrate measurable improvements in email campaign metrics</li>
                        <li><strong>Automation Effectiveness:</strong> Maximize the performance of your nurture sequences and workflows</li>
                        <li><strong>Revenue Generation:</strong> Better open rates lead to higher click-through rates and conversions</li>
                        <li><strong>Brand Reputation:</strong> Professional, engaging subject lines build trust with your audience</li>
                        <li><strong>Competitive Advantage:</strong> Stand out in crowded inboxes with compelling subject lines</li>
                    </ul>
                    
                    <p>By using our Email Subject Line Scorer, you can systematically improve every email you send through GoHighLevel, leading to better campaign results and happier clients.</p>
                </article>

                <article class="content-card">
                    <h2>How to Use the Email Subject Line Scorer</h2>
                    <p>Our tool is designed to be intuitive yet comprehensive. Here's how to get the most accurate scoring and optimization recommendations:</p>
                    
                    <ol>
                        <li><strong>Input Your Subject Line:</strong> Paste or type your current email subject line</li>
                        <li><strong>Select Email Type:</strong> Choose the category that best describes your email</li>
                        <li><strong>Define Target Audience:</strong> Specify whether you're targeting B2B, B2C, or other segments</li>
                        <li><strong>Get Instant Scoring:</strong> Receive a comprehensive score and detailed analysis</li>
                        <li><strong>Review Recommendations:</strong> Apply the optimization suggestions to improve your subject line</li>
                        <li><strong>Test Alternatives:</strong> Use the suggested alternatives for A/B testing</li>
                        <li><strong>Track Performance:</strong> Monitor how optimized subject lines perform in your campaigns</li>
                    </ol>
                    
                    <p><strong>Pro Tip:</strong> Score multiple subject line variations before sending to identify the best option. Even small improvements can lead to significant performance gains.</p>
                </article>

                <article class="content-card">
                    <h2>Use Cases for GoHighLevel Agencies</h2>
                    <p>Subject line optimization is invaluable for GoHighLevel agencies managing multiple client accounts and campaigns:</p>
                    
                    <div class="use-cases">
                        <h3>Client Campaign Optimization</h3>
                        <p>Score and optimize subject lines for different client industries, ensuring each campaign follows best practices for maximum engagement.</p>
                        
                        <h3>Automation Sequence Enhancement</h3>
                        <p>Optimize subject lines across nurture sequences, welcome series, and abandoned cart flows to improve overall automation performance.</p>
                        
                        <h3>Performance Benchmarking</h3>
                        <p>Establish subject line performance benchmarks for different industries and email types to set realistic client expectations.</p>
                        
                        <h3>Client Education & Training</h3>
                        <p>Use scoring results to educate clients on email best practices and demonstrate the value of optimization efforts.</p>
                        
                        <h3>Campaign Strategy Development</h3>
                        <p>Develop data-driven subject line strategies based on scoring insights and industry best practices.</p>
                        
                        <h3>Competitive Analysis</h3>
                        <p>Score competitor subject lines to understand industry trends and identify optimization opportunities.</p>
                    </div>
                </article>

                <article class="content-card">
                    <h2>Subject Line Optimization Best Practices</h2>
                    <p>To create high-scoring subject lines that drive results, follow these proven optimization strategies:</p>
                    
                    <h3>Length & Readability</h3>
                    <ul>
                        <li>Keep subject lines under 50 characters for mobile optimization</li>
                        <li>Use clear, concise language that's easy to scan</li>
                        <li>Avoid unnecessary punctuation and special characters</li>
                        <li>Ensure the full subject line is visible on all devices</li>
                    </ul>
                    
                    <h3>Psychological Triggers</h3>
                    <ul>
                        <li>Use curiosity gaps to encourage opens</li>
                        <li>Incorporate urgency and scarcity when appropriate</li>
                        <li>Add personalization elements for better engagement</li>
                        <li>Use emotional words that resonate with your audience</li>
                    </ul>
                    
                    <h3>Spam Filter Avoidance</h3>
                    <ul>
                        <li>Avoid excessive use of capital letters and exclamation points</li>
                        <li>Steer clear of spam trigger words like "FREE," "ACT NOW," etc.</li>
                        <li>Maintain a good text-to-image ratio in your emails</li>
                        <li>Use proper authentication and sender reputation management</li>
                    </ul>
                    
                    <h3>Brand Consistency</h3>
                    <ul>
                        <li>Maintain consistent voice and tone across all subject lines</li>
                        <li>Use brand-specific language and terminology</li>
                        <li>Ensure subject lines align with your overall messaging strategy</li>
                        <li>Test subject lines with your target audience for feedback</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Integration with GoHighLevel Email Marketing</h2>
                    <p>Our Email Subject Line Scorer integrates seamlessly with your GoHighLevel workflow to create a comprehensive email optimization strategy:</p>
                    
                    <h3>Campaign Builder Integration</h3>
                    <p>Use the scorer to optimize subject lines for campaigns created in GoHighLevel:</p>
                    <ul>
                        <li>Score subject lines before launching campaigns</li>
                        <li>Create multiple variations for A/B testing</li>
                        <li>Optimize subject lines based on campaign performance data</li>
                        <li>Maintain consistency across campaign series</li>
                    </ul>
                    
                    <h3>Automation Workflow Optimization</h3>
                    <p>Optimize subject lines throughout your automation sequences:</p>
                    <ul>
                        <li>Score subject lines for welcome series and nurture sequences</li>
                        <li>Optimize abandoned cart and re-engagement emails</li>
                        <li>Improve performance of birthday and anniversary campaigns</li>
                        <li>Enhance onboarding and educational email sequences</li>
                    </ul>
                    
                    <h3>Performance Tracking & Analysis</h3>
                    <p>Monitor and optimize subject line performance over time:</p>
                    <ul>
                        <li>Track subject line scores vs. actual performance</li>
                        <li>Identify patterns in high-performing subject lines</li>
                        <li>Use insights to improve future subject line creation</li>
                        <li>Build subject line performance databases for clients</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Advanced Subject Line Strategies</h2>
                    <p>Beyond basic optimization, consider these advanced strategies to maximize your subject line effectiveness:</p>
                    
                    <h3>Personalization & Segmentation</h3>
                    <p>Create highly targeted subject lines:</p>
                    <ul>
                        <li>Use subscriber data for dynamic personalization</li>
                        <li>Create segment-specific subject line strategies</li>
                        <li>Test behavioral triggers and preferences</li>
                        <li>Implement location-based personalization</li>
                    </ul>
                    
                    <h3>Psychological Optimization</h3>
                    <p>Leverage human psychology for better engagement:</p>
                    <ul>
                        <li>Use social proof and authority indicators</li>
                        <li>Implement loss aversion and scarcity principles</li>
                        <li>Create curiosity gaps that drive opens</li>
                        <li>Use emotional triggers that resonate with your audience</li>
                    </ul>
                    
                    <h3>Seasonal & Trending Optimization</h3>
                    <p>Stay relevant with timely subject lines:</p>
                    <ul>
                        <li>Incorporate seasonal themes and holidays</li>
                        <li>Reference trending topics and current events</li>
                        <li>Use time-sensitive language when appropriate</li>
                        <li>Adapt subject lines for different time zones</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Industry Standards and Benchmarks</h2>
                    <p>Understanding industry standards helps you set appropriate subject line goals and measure success:</p>
                    
                    <h3>Subject Line Length Standards</h3>
                    <ul>
                        <li><strong>Mobile Optimization:</strong> 30-50 characters for full visibility</li>
                        <li><strong>Desktop Optimization:</strong> 50-70 characters for detailed messaging</li>
                        <li><strong>Preview Text:</strong> 25-35 characters for mobile preview</li>
                        <li><strong>Brand Recognition:</strong> Include brand name when space allows</li>
                    </ul>
                    
                    <h3>Open Rate Benchmarks by Industry</h3>
                    <ul>
                        <li><strong>B2B Services:</strong> 15-25% average open rate</li>
                        <li><strong>E-commerce:</strong> 20-30% average open rate</li>
                        <li><strong>Non-profit:</strong> 25-35% average open rate</li>
                        <li><strong>Media & Publishing:</strong> 20-30% average open rate</li>
                        <li><strong>Technology:</strong> 18-28% average open rate</li>
                    </ul>
                    
                    <h3>Subject Line Performance Factors</h3>
                    <ul>
                        <li><strong>Personalization:</strong> 26% higher open rates</li>
                        <li><strong>Urgency:</strong> 22% improvement in open rates</li>
                        <li><strong>Curiosity:</strong> 18% increase in engagement</li>
                        <li><strong>Emotional Triggers:</strong> 15% better performance</li>
                    </ul>
                    
                    <h3>Testing Frequency Recommendations</h3>
                    <ul>
                        <li><strong>High-Volume Senders:</strong> Test subject lines weekly</li>
                        <li><strong>Medium-Volume Senders:</strong> Test subject lines bi-weekly</li>
                        <li><strong>Low-Volume Senders:</strong> Test subject lines monthly</li>
                        <li><strong>New Campaigns:</strong> Always test subject line variations</li>
                    </ul>
                    
                    <p><strong>Remember:</strong> These benchmarks vary by industry, audience, and email type. Focus on improving your own performance over time rather than just meeting industry averages.</p>
                </article>
            </div>
        </div>
    </section>

    <!-- Related Tools -->
    <section class="related-tools">
        <div class="container">
            <h2>Related Tools</h2>
            <div class="tools-grid">
                <a href="ab-testing.php" class="tool-link">
                    <h3>A/B Testing Calculator</h3>
                    <p>Test subject line variations and calculate statistical significance</p>
                </a>
                <a href="funnel-calculator.php" class="tool-link">
                    <h3>Funnel Calculator</h3>
                    <p>Analyze email funnel performance and optimize conversion rates</p>
                </a>
                <a href="roi-calculator.php" class="tool-link">
                    <h3>ROI Calculator</h3>
                    <p>Calculate email marketing ROI and campaign performance</p>
                </a>
                <a href="lead-scoring.php" class="tool-link">
                    <h3>Lead Scoring Tool</h3>
                    <p>Score and qualify leads from your email campaigns</p>
                </a>
            </div>
        </div>
    </section>

    <?php inc('includes/footer.php'); ?>
    <script src="common.js"></script>
    <script>`n    `n    // Load footer`n    fetch("footer.php")`n        .then(response => response.text())`n        .then(data => {`n            document.getElementById("footer-placeholder").innerHTML = data;`n        });`n});`n`n
        // Character counter
        document.getElementById('subjectLine').addEventListener('input', function() {
            const charCount = this.value.length;
            document.getElementById('charCount').textContent = charCount;
            
            // Change color based on character count
            const charCountSpan = document.getElementById('charCount');
            if (charCount > 70) {
                charCountSpan.style.color = '#e74c3c'; // Red
            } else if (charCount > 50) {
                charCountSpan.style.color = '#f39c12'; // Orange
            } else {
                charCountSpan.style.color = '#27ae60'; // Green
            }
        });

        function scoreSubjectLine() {
            const subjectLine = document.getElementById('subjectLine').value.trim();
            const emailType = document.getElementById('emailType').value;
            const targetAudience = document.getElementById('targetAudience').value;
            
            if (!subjectLine) {
                alert('Please enter a subject line to score.');
                return;
            }
            
            // Calculate scores
            const scores = calculateScores(subjectLine, emailType, targetAudience);
            
            // Display results
            displayResults(scores, subjectLine);
            
            document.getElementById('scoringResult').style.display = 'block';
        }
        
        function calculateScores(subjectLine, emailType, targetAudience) {
            let totalScore = 0;
            const maxScore = 100;
            const analysis = {};
            
            // Length scoring (25 points)
            const length = subjectLine.length;
            if (length >= 30 && length <= 50) {
                analysis.length = { score: 25, feedback: "Perfect length for mobile optimization" };
            } else if (length >= 20 && length <= 70) {
                analysis.length = { score: 20, feedback: "Good length, but could be optimized" };
            } else if (length < 20) {
                analysis.length = { score: 10, feedback: "Too short - may lack context" };
            } else {
                analysis.length = { score: 5, feedback: "Too long - may be truncated on mobile" };
            }
            totalScore += analysis.length.score;
            
            // Spam filter avoidance (20 points)
            const spamWords = ['FREE', 'ACT NOW', 'LIMITED TIME', 'URGENT', 'WINNER', 'CONGRATULATIONS'];
            const upperCaseCount = (subjectLine.match(/[A-Z]/g) || []).length;
            const exclamationCount = (subjectLine.match(/!/g) || []).length;
            
            let spamScore = 20;
            if (spamWords.some(word => subjectLine.toUpperCase().includes(word))) {
                spamScore -= 10;
            }
            if (upperCaseCount > length * 0.3) {
                spamScore -= 5;
            }
            if (exclamationCount > 1) {
                spamScore -= 5;
            }
            
            analysis.spam = { 
                score: Math.max(0, spamScore), 
                feedback: spamScore < 15 ? "Contains elements that may trigger spam filters" : "Good spam filter compliance"
            };
            totalScore += analysis.spam.score;
            
            // Psychological triggers (25 points)
            const curiosityWords = ['secret', 'revealed', 'discover', 'unveiled', 'behind the scenes'];
            const urgencyWords = ['today', 'now', 'limited', 'expires', 'deadline'];
            const personalWords = ['you', 'your', 'personal', 'exclusive', 'custom'];
            
            let triggerScore = 0;
            if (curiosityWords.some(word => subjectLine.toLowerCase().includes(word))) triggerScore += 8;
            if (urgencyWords.some(word => subjectLine.toLowerCase().includes(word))) triggerScore += 8;
            if (personalWords.some(word => subjectLine.toLowerCase().includes(word))) triggerScore += 9;
            
            analysis.triggers = { 
                score: triggerScore, 
                feedback: triggerScore > 15 ? "Strong psychological triggers" : "Could benefit from more engaging triggers"
            };
            totalScore += analysis.triggers.score;
            
            // Brand consistency (15 points)
            const brandScore = 15; // Simplified for demo
            analysis.brand = { 
                score: brandScore, 
                feedback: "Good brand consistency"
            };
            totalScore += analysis.brand.score;
            
            // Industry optimization (15 points)
            let industryScore = 15;
            if (emailType === 'promotional' && targetAudience === 'b2c') {
                if (subjectLine.toLowerCase().includes('sale') || subjectLine.toLowerCase().includes('offer')) {
                    industryScore = 15;
                } else {
                    industryScore = 10;
                }
            }
            
            analysis.industry = { 
                score: industryScore, 
                feedback: "Well-optimized for your industry and email type"
            };
            totalScore += analysis.industry.score;
            
            return {
                totalScore: Math.min(maxScore, totalScore),
                analysis: analysis,
                grade: getGrade(totalScore),
                recommendations: getRecommendations(analysis, subjectLine)
            };
        }
        
        function getGrade(score) {
            if (score >= 90) return "A+ (Excellent)";
            if (score >= 80) return "A (Very Good)";
            if (score >= 70) return "B+ (Good)";
            if (score >= 60) return "B (Above Average)";
            if (score >= 50) return "C (Average)";
            if (score >= 40) return "D (Below Average)";
            return "F (Needs Improvement)";
        }
        
        function getRecommendations(analysis, subjectLine) {
            const recommendations = [];
            
            if (analysis.length.score < 20) {
                recommendations.push("Optimize length for better mobile visibility");
            }
            
            if (analysis.spam.score < 15) {
                recommendations.push("Reduce spam trigger words and excessive punctuation");
            }
            
            if (analysis.triggers.score < 15) {
                recommendations.push("Add psychological triggers like curiosity, urgency, or personalization");
            }
            
            if (analysis.industry.score < 15) {
                recommendations.push("Optimize for your specific industry and email type");
            }
            
            return recommendations;
        }
        
        function displayResults(scores, subjectLine) {
            const overallScoreDiv = document.getElementById('overallScore');
            const detailedAnalysisDiv = document.getElementById('detailedAnalysis');
            const optimizationTipsDiv = document.getElementById('optimizationTips');
            const alternativeSuggestionsDiv = document.getElementById('alternativeSuggestions');
            
            // Display overall score
            overallScoreDiv.innerHTML = `
                <div class="score-display">
                    <h4>Overall Score: ${scores.totalScore}/100</h4>
                    <p class="grade">${scores.grade}</p>
                    <div class="score-bar">
                        <div class="score-fill" style="width: ${scores.totalScore}%"></div>
                    </div>
                </div>
            `;
            
            // Display detailed analysis
            detailedAnalysisDiv.innerHTML = `
                <h4>Detailed Analysis</h4>
                <div class="analysis-grid">
                    <div class="analysis-item">
                        <h5>Length Optimization</h5>
                        <p class="score">${scores.analysis.length.score}/25</p>
                        <p class="feedback">${scores.analysis.length.feedback}</p>
                    </div>
                    <div class="analysis-item">
                        <h5>Spam Filter Avoidance</h5>
                        <p class="score">${scores.analysis.spam.score}/20</p>
                        <p class="feedback">${scores.analysis.spam.feedback}</p>
                    </div>
                    <div class="analysis-item">
                        <h5>Psychological Triggers</h5>
                        <p class="score">${scores.analysis.triggers.score}/25</p>
                        <p class="feedback">${scores.analysis.triggers.feedback}</p>
                    </div>
                    <div class="analysis-item">
                        <h5>Brand Consistency</h5>
                        <p class="score">${scores.analysis.brand.score}/15</p>
                        <p class="feedback">${scores.analysis.brand.feedback}</p>
                    </div>
                    <div class="analysis-item">
                        <h5>Industry Optimization</h5>
                        <p class="score">${scores.analysis.industry.score}/15</p>
                        <p class="feedback">${scores.analysis.industry.feedback}</p>
                    </div>
                </div>
            `;
            
            // Display optimization tips
            optimizationTipsDiv.innerHTML = `
                <h4>Optimization Recommendations</h4>
                <ul>
                    ${scores.recommendations.map(rec => `<li>${rec}</li>`).join('')}
                </ul>
            `;
            
            // Display alternative suggestions
            alternativeSuggestionsDiv.innerHTML = `
                <h4>Alternative Subject Line Ideas</h4>
                <div class="alternatives">
                    <p><strong>Curiosity-based:</strong> "The ${subjectLine.split(' ').slice(0, 3).join(' ')} secret you need to know"</p>
                    <p><strong>Urgency-based:</strong> "${subjectLine} - Limited time opportunity"</p>
                    <p><strong>Personalized:</strong> "Your exclusive ${subjectLine} guide"</p>
                    <p><strong>Benefit-focused:</strong> "How ${subjectLine} can transform your results"</p>
                </div>
            `;
        }
    </script>
</body>
</html>




