﻿<?php
require_once __DIR__ . '/config.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Business Name Generator for GoHighLevel | Free Company Naming Tool</title>
    <meta name="description" content="Free business name generator for GoHighLevel users. Create creative and memorable business names for your clients. Perfect for agencies helping businesses establish their brand identity.">
    <meta name="keywords" content="business name generator, company name generator, business naming tool, GoHighLevel agency, brand naming, company names, business branding, creative business names">
    <meta name="author" content="Paddle CRM">
    <meta name="robots" content="index, follow">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:title" content="Business Name Generator for GoHighLevel">
    <meta property="og:description" content="Free business name generator for GoHighLevel users. Create creative and memorable business names for your clients.">
    <meta property="og:url" content="https://yourdomain.com/business-name-generator.php">
    <meta property="og:image" content="https://yourdomain.com/images/business-name-generator-og.jpg">
    
    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:title" content="Business Name Generator for GoHighLevel">
    <meta property="twitter:description" content="Free business name generator for GoHighLevel users. Create creative and memorable business names for your clients.">
    <meta property="twitter:image" content="https://yourdomain.com/images/business-name-generator-og.jpg">
    
    <!-- Schema.org structured data -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebApplication",
        "name": "Business Name Generator for GoHighLevel",
        "description": "Free tool to generate creative and memorable business names for new companies and brands",
        "url": "https://yourdomain.com/business-name-generator.php",
        "applicationCategory": "BusinessApplication",
        "operatingSystem": "Web Browser",
        "offers": {
            "@type": "Offer",
            "price": "0",
            "priceCurrency": "USD"
        },
        "provider": {
            "@type": "Organization",
            "name": "Paddle CRM",
            "description": "WhiteLabel GoHighLevel Agency"
        }
    }
    </script>
    
    <link rel="stylesheet" href="styles.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <?php inc('includes/header.php'); ?>

    <!-- Hero Section -->
    <section class="hero tool-hero">
        <div class="container">
            <nav class="breadcrumb">
                <a href="index.php">Home</a> > <span>Business Name Generator</span>
            </nav>
            <div class="hero-content">
                <div class="hero-text">
                    <h1 class="hero-title">Business Name Generator for GoHighLevel</h1>
                    <p class="hero-subtitle">Create creative and memorable business names for your clients and their brand identity</p>
                    <div class="hero-stats">
                        <div class="stat-item">
                            <span class="stat-number">Professional</span>
                            <span class="stat-label">Quality</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number">GoHighLevel</span>
                            <span class="stat-label">Optimized</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number">100%</span>
                            <span class="stat-label">Free Tool</span>
                        </div>
                    </div>
                </div>
                <div class="hero-visual">
                    <div class="hero-image">
                        <div class="floating-card card-1">
                            <span class="card-icon">🏢</span>
                            <span class="card-text">Business</span>
                        </div>
                        <div class="floating-card card-2">
                            <span class="card-icon">⚡</span>
                            <span class="card-text">Fast</span>
                        </div>
                        <div class="floating-card card-3">
                            <span class="card-icon">🎯</span>
                            <span class="card-text">Creative</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Tool Section -->
    <section class="tool-section">
        <div class="container">
            <div class="tool-card featured">
                <div class="tool-header">
                    <div class="tool-icon">🏢</div>
                    <h2>Business Name Generator</h2>
                    <p>Professional business naming tool designed specifically for GoHighLevel users and agencies</p>
                </div>
                
                <div class="tool-interface">
                    <div class="input-group">
                        <label for="businessType">Business Type/Industry</label>
                        <select id="businessType">
                            <option value="">Select Business Type</option>
                            <option value="tech">Technology</option>
                            <option value="health">Healthcare</option>
                            <option value="finance">Finance</option>
                            <option value="retail">Retail</option>
                            <option value="food">Food & Beverage</option>
                            <option value="fitness">Fitness & Wellness</option>
                            <option value="creative">Creative Services</option>
                            <option value="consulting">Consulting</option>
                            <option value="education">Education</option>
                            <option value="real-estate">Real Estate</option>
                            <option value="automotive">Automotive</option>
                            <option value="beauty">Beauty & Personal Care</option>
                            <option value="legal">Legal Services</option>
                            <option value="other">Other</option>
                        </select>
                    </div>
                    
                    <div class="input-group">
                        <label for="businessStyle">Naming Style</label>
                        <select id="businessStyle">
                            <option value="">Select Style</option>
                            <option value="modern">Modern & Tech</option>
                            <option value="traditional">Traditional & Professional</option>
                            <option value="creative">Creative & Unique</option>
                            <option value="short">Short & Memorable</option>
                            <option value="descriptive">Descriptive & Clear</option>
                        </select>
                    </div>
                    
                    <div class="input-group">
                        <label for="keywords">Keywords (Optional)</label>
                        <input type="text" id="keywords" placeholder="Enter relevant keywords separated by commas...">
                    </div>
                    
                    <div class="button-group">
                        <button class="btn btn-primary" onclick="generateBusinessNames()">Generate Business Names</button>
                        <button class="btn btn-secondary" onclick="generateMoreNames()">Generate More Names</button>
                        <button class="btn btn-secondary" onclick="clearResults()">Clear Results</button>
                    </div>
                    
                    <div class="result" id="businessNamesResult" style="display: none;">
                        <h3>Generated Business Names</h3>
                        <div class="names-grid" id="namesGrid"></div>
                        <div class="name-actions">
                            <button class="btn btn-primary" onclick="exportNames()">Export Names</button>
                            <button class="btn btn-secondary" onclick="checkDomainAvailability()">Check Domains</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Content Section -->
    <section class="content-section">
        <div class="container">
            <div class="content-grid">
                <article class="content-card">
                    <h2>What is a Business Name Generator?</h2>
                    <p>A business name generator is a tool that creates creative, memorable, and brandable names for new businesses. It combines industry knowledge, naming conventions, and creative algorithms to suggest names that align with business goals and target audiences.</p>
                    
                    <p>For GoHighLevel users, effective business naming is crucial for:</p>
                    <ul>
                        <li><strong>Client Branding:</strong> Helping clients establish strong brand identities</li>
                        <li><strong>Market Positioning:</strong> Creating names that differentiate from competitors</li>
                        <li><strong>Memorability:</strong> Ensuring names are easy to remember and share</li>
                        <li><strong>Domain Availability:</strong> Finding names with available web domains</li>
                        <li><strong>Legal Protection:</strong> Suggesting names that can be trademarked</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Why GoHighLevel Users Need This Tool</h2>
                    <p>As a GoHighLevel agency, you're constantly working with clients who need to establish or rebrand their businesses. A strong business name is the foundation of any successful brand strategy and marketing campaign.</p>
                    
                    <ul>
                        <li><strong>Client Services:</strong> Offer business naming as part of your service package</li>
                        <li><strong>Brand Development:</strong> Help clients build complete brand identities</li>
                        <li><strong>Competitive Advantage:</strong> Stand out by offering comprehensive branding services</li>
                        <li><strong>Project Efficiency:</strong> Generate multiple name options quickly</li>
                        <li><strong>Professional Expertise:</strong> Demonstrate knowledge in brand development</li>
                        <li><strong>Revenue Growth:</strong> Add business naming to your service offerings</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>How to Use the Business Name Generator</h2>
                    <p>Our business name generator is designed to be intuitive and comprehensive:</p>
                    
                    <ol>
                        <li><strong>Select Business Type:</strong> Choose the industry or business category that best fits your client</li>
                        <li><strong>Choose Naming Style:</strong> Select the tone and approach that aligns with the brand personality</li>
                        <li><strong>Add Keywords:</strong> Include relevant terms that should be incorporated into the name</li>
                        <li><strong>Generate Names:</strong> Click to create multiple name options</li>
                        <li><strong>Review Results:</strong> Evaluate names for memorability, brandability, and availability</li>
                        <li><strong>Refine & Generate More:</strong> Use different parameters to explore more options</li>
                        <li><strong>Export & Present:</strong> Share the best options with your client</li>
                    </ol>
                </article>

                <article class="content-card">
                    <h2>Use Cases for GoHighLevel Agencies</h2>
                    <p>This tool serves multiple purposes in your daily GoHighLevel operations:</p>
                    
                    <ul>
                        <li><strong>New Client Onboarding:</strong> Help new clients establish their brand identity</li>
                        <li><strong>Rebranding Projects:</strong> Assist existing clients with name changes</li>
                        <li><strong>Product Launches:</strong> Name new products or service lines</li>
                        <li><strong>Campaign Development:</strong> Create names for marketing campaigns</li>
                        <li><strong>Event Naming:</strong> Generate names for webinars, workshops, or events</li>
                        <li><strong>Funnel Naming:</strong> Create memorable names for sales funnels</li>
                        <li><strong>Service Packages:</strong> Name different service tiers or packages</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Business Naming Best Practices</h2>
                    <p>To get the most out of business naming for your GoHighLevel clients:</p>
                    
                    <ul>
                        <li><strong>Memorability:</strong> Choose names that are easy to remember and pronounce</li>
                        <li><strong>Brandability:</strong> Ensure names can be developed into strong brands</li>
                        <li><strong>Domain Availability:</strong> Check if web domains are available for the names</li>
                        <li><strong>Legal Considerations:</strong> Verify names can be trademarked and aren't already in use</li>
                        <li><strong>Cultural Sensitivity:</strong> Ensure names work across different cultures and languages</li>
                        <li><strong>Future Growth:</strong> Choose names that won't limit business expansion</li>
                        <li><strong>SEO Considerations:</strong> Consider how names will perform in search results</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Integration with GoHighLevel</h2>
                    <p>This tool integrates seamlessly with your GoHighLevel workflow:</p>
                    
                    <ul>
                        <li><strong>Client Discovery:</strong> Use during initial client consultations to demonstrate expertise</li>
                        <li><strong>Project Planning:</strong> Incorporate business naming into project proposals</li>
                        <li><strong>Brand Development:</strong> Create complete brand packages including names, colors, and messaging</li>
                        <li><strong>Funnel Creation:</strong> Use generated names for funnel and campaign naming</li>
                        <li><strong>Client Presentations:</strong> Present multiple name options with rationale</li>
                        <li><strong>Service Expansion:</strong> Add business naming as a premium service offering</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Industry-Specific Naming Strategies</h2>
                    <p>Different industries require different naming approaches:</p>
                    
                    <ul>
                        <li><strong>Technology:</strong> Focus on innovation, speed, and cutting-edge solutions</li>
                        <li><strong>Healthcare:</strong> Emphasize trust, care, and professional expertise</li>
                        <li><strong>Finance:</strong> Highlight stability, security, and growth potential</li>
                        <li><strong>Retail:</strong> Focus on customer experience and product quality</li>
                        <li><strong>Food & Beverage:</strong> Emphasize taste, quality, and experience</li>
                        <li><strong>Creative Services:</strong> Highlight innovation, artistry, and unique perspectives</li>
                        <li><strong>Consulting:</strong> Focus on expertise, results, and professional credibility</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Advanced Naming Strategies</h2>
                    <p>Beyond basic name generation, consider these advanced strategies:</p>
                    
                    <ul>
                        <li><strong>Compound Names:</strong> Combine two relevant words to create unique names</li>
                        <li><strong>Acronyms:</strong> Use initials to create memorable abbreviations</li>
                        <li><strong>Invented Words:</strong> Create completely new words that are brandable</li>
                        <li><strong>Foreign Language:</strong> Incorporate words from other languages for uniqueness</li>
                        <li><strong>Sound Symbolism:</strong> Use sounds that convey the desired brand attributes</li>
                        <li><strong>Storytelling:</strong> Choose names that tell a story about the business</li>
                        <li><strong>Future-Proofing:</strong> Select names that won't become outdated</li>
                    </ul>
                </article>
            </div>
        </div>
    </section>

    <!-- Related Tools -->
    <section class="related-tools">
        <div class="container">
            <h2>Related GoHighLevel Tools</h2>
            <div class="tools-grid">
                <a href="color-palette-generator.php" class="tool-link">
                    <div class="tool-icon">🎨</div>
                    <h3>Color Palette Generator</h3>
                    <p>Create professional color schemes for your brands</p>
                </a>
                <a href="social-media-caption-generator.php" class="tool-link">
                    <div class="tool-icon">📱</div>
                    <h3>Social Media Caption Generator</h3>
                    <p>Generate engaging social media content</p>
                </a>
                <a href="email-template-builder.php" class="tool-link">
                    <div class="tool-icon">📧</div>
                    <h3>Email Template Builder</h3>
                    <p>Create professional email templates</p>
                </a>
            </div>
        </div>
    </section>

    <?php inc('includes/footer.php'); ?>
    <script src="common.js"></script>
    <script>`n    `n    // Load footer`n    fetch("footer.php")`n        .then(response => response.text())`n        .then(data => {`n            document.getElementById("footer-placeholder").innerHTML = data;`n        });`n});`n`n
        // Business Name Generator functionality
        const businessNames = {
            tech: {
                modern: ['NexusFlow', 'QuantumLeap', 'CyberSync', 'DataPulse', 'TechVault', 'InnovateHub', 'DigitalForge', 'CodeCraft', 'SmartStack', 'FutureLabs'],
                traditional: ['Advanced Systems', 'Professional Solutions', 'Enterprise Tech', 'Business Systems', 'Corporate Technology', 'Industrial Computing', 'Commercial Software', 'Business Intelligence', 'Corporate Solutions', 'Professional Technology'],
                creative: ['ByteBrew', 'PixelPulse', 'CircuitSage', 'DataDragon', 'TechWhisper', 'CodeCanvas', 'DigitalDream', 'InnovationForge', 'TechTapestry', 'FutureFusion'],
                short: ['Nexus', 'Quantum', 'Cyber', 'Data', 'Tech', 'Innovate', 'Digital', 'Code', 'Smart', 'Future'],
                descriptive: ['Cloud Computing Solutions', 'Mobile App Development', 'Data Analytics Services', 'Cybersecurity Solutions', 'AI Development Company', 'Web Development Agency', 'Software Consulting', 'IT Infrastructure', 'Digital Transformation', 'Technology Consulting']
            },
            health: {
                modern: ['VitaFlow', 'HealthSync', 'WellnessHub', 'CareConnect', 'VitalityPlus', 'HealthForge', 'WellnessWave', 'CarePulse', 'VitaTech', 'HealthLink'],
                traditional: ['Professional Healthcare', 'Medical Solutions', 'Health Services', 'Wellness Center', 'Medical Group', 'Healthcare Partners', 'Wellness Institute', 'Medical Associates', 'Health Professionals', 'Wellness Solutions'],
                creative: ['VitaBloom', 'HealthHarbor', 'WellnessWhisper', 'CareCanvas', 'VitalityVault', 'HealthHorizon', 'WellnessWings', 'CareCompass', 'VitaVision', 'HealthHaven'],
                short: ['Vita', 'Health', 'Well', 'Care', 'Vital', 'Med', 'Life', 'Pure', 'Fresh', 'Natural'],
                descriptive: ['Family Medical Practice', 'Wellness & Nutrition Center', 'Physical Therapy Clinic', 'Mental Health Services', 'Dental Care Practice', 'Alternative Medicine Center', 'Fitness & Wellness', 'Health & Wellness Coaching', 'Medical Equipment Sales', 'Healthcare Technology']
            },
            finance: {
                modern: ['WealthFlow', 'FinanceSync', 'MoneyHub', 'CapitalConnect', 'InvestmentPlus', 'FinanceForge', 'WealthWave', 'CapitalPulse', 'MoneyTech', 'FinanceLink'],
                traditional: ['Professional Financial Services', 'Investment Solutions', 'Wealth Management', 'Financial Planning', 'Investment Group', 'Financial Partners', 'Wealth Institute', 'Investment Associates', 'Financial Professionals', 'Wealth Solutions'],
                creative: ['WealthBloom', 'FinanceHarbor', 'MoneyWhisper', 'CapitalCanvas', 'InvestmentVault', 'FinanceHorizon', 'WealthWings', 'CapitalCompass', 'MoneyVision', 'FinanceHaven'],
                short: ['Wealth', 'Finance', 'Money', 'Capital', 'Invest', 'Fund', 'Trust', 'Bank', 'Credit', 'Asset'],
                descriptive: ['Personal Financial Planning', 'Business Investment Services', 'Retirement Planning Specialists', 'Tax Preparation Services', 'Estate Planning Law', 'Insurance & Financial Services', 'Small Business Banking', 'Investment Advisory Services', 'Financial Technology Solutions', 'Wealth Management Consulting']
            }
        };

        function generateBusinessNames() {
            const businessType = document.getElementById('businessType').value;
            const businessStyle = document.getElementById('businessStyle').value;
            const keywords = document.getElementById('keywords').value;
            
            if (!businessType || !businessStyle) {
                alert('Please select both business type and naming style');
                return;
            }
            
            let names = [];
            
            // Get base names from the selected category
            if (businessNames[businessType] && businessNames[businessType][businessStyle]) {
                names = [...businessNames[businessType][businessStyle]];
            }
            
            // Add keyword-based names if keywords provided
            if (keywords.trim()) {
                const keywordArray = keywords.split(',').map(k => k.trim().toLowerCase());
                const keywordNames = generateKeywordBasedNames(keywordArray, businessStyle);
                names = [...names, ...keywordNames];
            }
            
            // Shuffle and limit results
            names = shuffleArray(names).slice(0, 15);
            
            displayNames(names);
        }

        function generateKeywordBasedNames(keywords, style) {
            const names = [];
            const suffixes = {
                modern: ['Tech', 'Hub', 'Flow', 'Sync', 'Pulse', 'Forge', 'Wave', 'Link', 'Vault', 'Labs'],
                traditional: ['Solutions', 'Services', 'Group', 'Partners', 'Associates', 'Professionals', 'Institute', 'Company', 'Corporation', 'Enterprises'],
                creative: ['Bloom', 'Harbor', 'Whisper', 'Canvas', 'Vault', 'Horizon', 'Wings', 'Compass', 'Vision', 'Haven'],
                short: ['', 'Pro', 'Plus', 'Max', 'Prime', 'Elite', 'Core', 'Base', 'Hub', 'Zone'],
                descriptive: ['Services', 'Solutions', 'Center', 'Group', 'Company', 'Associates', 'Partners', 'Professionals', 'Institute', 'Enterprises']
            };
            
            keywords.forEach(keyword => {
                suffixes[style].forEach(suffix => {
                    if (suffix) {
                        names.push(keyword.charAt(0).toUpperCase() + keyword.slice(1) + suffix);
                    } else {
                        names.push(keyword.charAt(0).toUpperCase() + keyword.slice(1));
                    }
                });
            });
            
            return names;
        }

        function generateMoreNames() {
            generateBusinessNames();
        }

        function clearResults() {
            document.getElementById('businessNamesResult').style.display = 'none';
            document.getElementById('namesGrid').innerHTML = '';
        }

        function displayNames(names) {
            const namesGrid = document.getElementById('namesGrid');
            let html = '';
            
            names.forEach((name, index) => {
                html += `
                    <div class="name-card">
                        <h4>${name}</h4>
                        <div class="name-actions">
                            <button class="btn btn-small" onclick="copyToClipboard('${name}')">Copy</button>
                            <button class="btn btn-small btn-secondary" onclick="checkDomain('${name}')">Check Domain</button>
                        </div>
                    </div>
                `;
            });
            
            namesGrid.innerHTML = html;
            document.getElementById('businessNamesResult').style.display = 'block';
        }

        function copyToClipboard(text) {
            navigator.clipboard.writeText(text).then(function() {
                const button = event.target;
                const originalText = button.textContent;
                button.textContent = 'Copied!';
                button.style.background = '#28a745';
                
                setTimeout(() => {
                    button.textContent = originalText;
                    button.style.background = '';
                }, 2000);
            }).catch(function(err) {
                console.error('Could not copy text: ', err);
                alert('Failed to copy name. Please copy manually: ' + text);
            });
        }

        function checkDomain(name) {
            const domain = name.toLowerCase().replace(/[^a-z0-9]/g, '') + '.com';
            window.open(`https://domains.google.com/registrar/search?searchTerm=${domain}`, '_blank');
        }

        function checkDomainAvailability() {
            const names = document.querySelectorAll('.name-card h4');
            names.forEach(name => {
                const domain = name.textContent.toLowerCase().replace(/[^a-z0-9]/g, '') + '.com';
                window.open(`https://domains.google.com/registrar/search?searchTerm=${domain}`, '_blank');
            });
        }

        function exportNames() {
            const names = Array.from(document.querySelectorAll('.name-card h4')).map(h4 => h4.textContent);
            const exportData = {
                timestamp: new Date().toISOString(),
                businessNames: names
            };
            
            const dataStr = JSON.stringify(exportData, null, 2);
            const dataBlob = new Blob([dataStr], {type: 'application/json'});
            
            const link = document.createElement('a');
            link.href = URL.createObjectURL(dataBlob);
            link.download = 'business-names.json';
            link.click();
        }

        function shuffleArray(array) {
            const shuffled = [...array];
            for (let i = shuffled.length - 1; i > 0; i--) {
                const j = Math.floor(Math.random() * (i + 1));
                [shuffled[i], shuffled[j]] = [shuffled[j], shuffled[i]];
            }
            return shuffled;
        }

        // Add more business types and styles
        businessNames.retail = {
            modern: ['RetailFlow', 'ShopSync', 'StoreHub', 'MarketConnect', 'RetailPlus', 'ShopForge', 'MarketWave', 'StorePulse', 'RetailTech', 'ShopLink'],
            traditional: ['Professional Retail', 'Retail Solutions', 'Store Services', 'Market Group', 'Retail Partners', 'Store Institute', 'Market Associates', 'Retail Professionals', 'Store Solutions', 'Market Services'],
            creative: ['RetailBloom', 'ShopHarbor', 'MarketWhisper', 'StoreCanvas', 'RetailVault', 'ShopHorizon', 'MarketWings', 'StoreCompass', 'RetailVision', 'ShopHaven'],
            short: ['Retail', 'Shop', 'Market', 'Store', 'Buy', 'Sell', 'Trade', 'Mart', 'Boutique', 'Emporium'],
            descriptive: ['Fashion Retail Store', 'Electronics Store', 'Home Goods Retail', 'Specialty Retail Shop', 'Online Retail Store', 'Boutique Clothing Store', 'Gift Shop', 'Convenience Store', 'Department Store', 'Retail Outlet']
        };

        businessNames.food = {
            modern: ['FoodFlow', 'CuisineSync', 'KitchenHub', 'TasteConnect', 'FoodPlus', 'KitchenForge', 'TasteWave', 'CuisinePulse', 'FoodTech', 'KitchenLink'],
            traditional: ['Professional Catering', 'Food Services', 'Restaurant Group', 'Catering Partners', 'Kitchen Institute', 'Food Associates', 'Cuisine Professionals', 'Kitchen Solutions', 'Food Services', 'Restaurant Company'],
            creative: ['FoodBloom', 'KitchenHarbor', 'TasteWhisper', 'CuisineCanvas', 'FoodVault', 'KitchenHorizon', 'TasteWings', 'CuisineCompass', 'FoodVision', 'KitchenHaven'],
            short: ['Food', 'Kitchen', 'Taste', 'Cuisine', 'Chef', 'Bite', 'Eat', 'Dine', 'Feast', 'Plate'],
            descriptive: ['Fine Dining Restaurant', 'Catering Services', 'Food Truck Business', 'Bakery & Cafe', 'Pizza Restaurant', 'Coffee Shop', 'Ice Cream Parlor', 'Food Delivery Service', 'Meal Prep Service', 'Food Consulting']
        };
    </script>

    <style>
        .names-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin: 20px 0;
        }

        .name-card {
            background: white;
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 20px;
            text-align: center;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }

        .name-card h4 {
            margin: 0 0 15px 0;
            color: #0a2038;
            font-size: 18px;
        }

        .name-actions {
            display: flex;
            gap: 10px;
            justify-content: center;
            margin-top: 15px;
        }

        .btn-small {
            padding: 8px 16px;
            font-size: 14px;
        }

        .name-actions .btn {
            margin: 0;
        }

        .result .name-actions {
            margin-top: 20px;
            justify-content: center;
        }

        .result .name-actions .btn {
            margin: 0 10px;
        }
    </style>
</body>
</html>




