﻿<?php
require_once __DIR__ . '/config.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Base64 Encoder/Decoder for GoHighLevel | Free Encoding Tool</title>
    <meta name="description" content="Free Base64 encoder and decoder for GoHighLevel users. Encode text to Base64 and decode Base64 to text. Perfect for agencies handling data encoding and API integrations.">
    <meta name="keywords" content="base64 encoder, base64 decoder, base64 converter, text encoding, data encoding, GoHighLevel agency, API integration">
    <meta name="author" content="Paddle CRM">
    <meta name="robots" content="index, follow">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:title" content="Base64 Encoder/Decoder for GoHighLevel">
    <meta property="og:description" content="Free Base64 encoder and decoder for GoHighLevel users. Encode text to Base64 and decode Base64 to text.">
    <meta property="og:url" content="https://yourdomain.com/base64-encoder-decoder.php">
    <meta property="og:image" content="https://yourdomain.com/images/base64-encoder-decoder-og.jpg">
    
    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:title" content="Base64 Encoder/Decoder for GoHighLevel">
    <meta property="twitter:description" content="Free Base64 encoder and decoder for GoHighLevel users. Encode text to Base64 and decode Base64 to text.">
    <meta property="twitter:image" content="https://yourdomain.com/images/base64-encoder-decoder-og.jpg">
    
    <!-- Schema.org structured data -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebApplication",
        "name": "Base64 Encoder/Decoder for GoHighLevel",
        "description": "Free tool to encode text to Base64 and decode Base64 to text",
        "url": "https://yourdomain.com/base64-encoder-decoder.php",
        "applicationCategory": "BusinessApplication",
        "operatingSystem": "Web Browser",
        "offers": {
            "@type": "Offer",
            "price": "0",
            "priceCurrency": "USD"
        },
        "provider": {
            "@type": "Organization",
            "name": "Paddle CRM",
            "description": "WhiteLabel GoHighLevel Agency"
        }
    }
    </script>
    
    <link rel="stylesheet" href="styles.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <?php inc('includes/header.php'); ?>

    <!-- Hero Section -->
    <section class="hero tool-hero">
        <div class="container">
            <nav class="breadcrumb">
                <a href="index.php">Home</a> > <span>Base64 Encoder/Decoder</span>
            </nav>
            <div class="hero-content">
                <div class="hero-text">
                    <h1 class="hero-title">Base64 Encoder/Decoder for GoHighLevel</h1>
                    <p class="hero-subtitle">Encode text to Base64 and decode Base64 to text for data handling, API integrations, and secure data transmission</p>
                    <div class="hero-stats">
                        <div class="stat-item">
                            <span class="stat-number">Professional</span>
                            <span class="stat-label">Quality</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number">GoHighLevel</span>
                            <span class="stat-label">Optimized</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number">100%</span>
                            <span class="stat-label">Free Tool</span>
                        </div>
                    </div>
                </div>
                <div class="hero-visual">
                    <div class="hero-image">
                        <div class="floating-card card-1">
                            <span class="card-icon">📝</span>
                            <span class="card-text">Base64</span>
                        </div>
                        <div class="floating-card card-2">
                            <span class="card-icon">⚡</span>
                            <span class="card-text">Fast</span>
                        </div>
                        <div class="floating-card card-3">
                            <span class="card-icon">🎯</span>
                            <span class="card-text">Accurate</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Tool Section -->
    <section class="tool-section">
        <div class="container">
            <div class="tool-card featured">
                <div class="tool-header">
                    <div class="tool-icon">📝</div>
                    <h2>Base64 Encoder/Decoder</h2>
                    <p>Professional Base64 encoding and decoding tool designed specifically for GoHighLevel users and agencies</p>
                </div>
                
                <div class="tool-interface">
                    <div class="encoding-tabs">
                        <button class="tab-btn active" onclick="showTab('encode')">Encode to Base64</button>
                        <button class="tab-btn" onclick="showTab('decode')">Decode from Base64</button>
                        <button class="tab-btn" onclick="showTab('file')">File Encoding</button>
                    </div>
                    
                    <div class="tab-content">
                        <!-- Encode Tab -->
                        <div id="encode-tab" class="tab-pane active">
                            <div class="input-group">
                                <label for="encodeInput">Text to Encode</label>
                                <textarea id="encodeInput" rows="8" placeholder="Enter the text you want to encode to Base64..."></textarea>
                                <div class="char-counter">
                                    <span id="encodeCharCounter">0</span> characters
                                </div>
                            </div>
                            
                            <div class="input-group">
                                <label for="encodeOptions">Encoding Options</label>
                                <div class="options-grid">
                                    <label class="checkbox-label">
                                        <input type="checkbox" id="encodeUrlSafe" checked>
                                        URL Safe (use - and _ instead of + and /)
                                    </label>
                                    <label class="checkbox-label">
                                        <input type="checkbox" id="encodePadding">
                                        Include Padding (=)
                                    </label>
                                    <label class="checkbox-label">
                                        <input type="checkbox" id="encodeNewlines">
                                        Handle Newlines
                                    </label>
                                </div>
                            </div>
                            
                            <div class="button-group">
                                <button class="btn btn-primary" onclick="encodeText()">Encode to Base64</button>
                                <button class="btn btn-secondary" onclick="clearEncode()">Clear</button>
                            </div>
                            
                            <div class="result" id="encodeResult" style="display: none;">
                                <h3>Encoded Result</h3>
                                <div class="result-display">
                                    <div class="result-item">
                                        <label>Original Text:</label>
                                        <div class="result-value" id="originalText"></div>
                                    </div>
                                    
                                    <div class="result-item">
                                        <label>Base64 Output:</label>
                                        <div class="result-value result-output" id="base64Output">
                                            <span id="base64Text"></span>
                                            <button class="copy-btn" onclick="copyResult('base64Text')">📋 Copy</button>
                                        </div>
                                    </div>
                                    
                                    <div class="result-item">
                                        <label>Output Length:</label>
                                        <div class="result-value" id="outputLength"></div>
                                    </div>
                                    
                                    <div class="result-item">
                                        <label>Encoding Ratio:</label>
                                        <div class="result-value" id="encodingRatio"></div>
                                    </div>
                                </div>
                                
                                <div class="result-actions">
                                    <button class="btn btn-primary" onclick="downloadEncoded()">Download Result</button>
                                    <button class="btn btn-secondary" onclick="testDecode()">Test Decode</button>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Decode Tab -->
                        <div id="decode-tab" class="tab-pane">
                            <div class="input-group">
                                <label for="decodeInput">Base64 to Decode</label>
                                <textarea id="decodeInput" rows="8" placeholder="Enter the Base64 string you want to decode..."></textarea>
                                <div class="char-counter">
                                    <span id="decodeCharCounter">0</span> characters
                                </div>
                            </div>
                            
                            <div class="input-group">
                                <label for="decodeOptions">Decoding Options</label>
                                <div class="options-grid">
                                    <label class="checkbox-label">
                                        <input type="checkbox" id="decodeUrlSafe" checked>
                                        Handle URL Safe Characters
                                    </label>
                                    <label class="checkbox-label">
                                        <input type="checkbox" id="decodeStrict">
                                        Strict Mode (validate input)
                                    </label>
                                    <label class="checkbox-label">
                                        <input type="checkbox" id="decodeBinary">
                                        Treat as Binary Data
                                    </label>
                                </div>
                            </div>
                            
                            <div class="button-group">
                                <button class="btn btn-primary" onclick="decodeText()">Decode from Base64</button>
                                <button class="btn btn-secondary" onclick="clearDecode()">Clear</button>
                            </div>
                            
                            <div class="result" id="decodeResult" style="display: none;">
                                <h3>Decoded Result</h3>
                                <div class="result-display">
                                    <div class="result-item">
                                        <label>Base64 Input:</label>
                                        <div class="result-value" id="base64Input"></div>
                                    </div>
                                    
                                    <div class="result-item">
                                        <label>Decoded Text:</label>
                                        <div class="result-value result-output" id="decodedText">
                                            <span id="decodedTextContent"></span>
                                            <button class="copy-btn" onclick="copyResult('decodedTextContent')">📋 Copy</button>
                                        </div>
                                    </div>
                                    
                                    <div class="result-item">
                                        <label>Data Type:</label>
                                        <div class="result-value" id="dataType"></div>
                                    </div>
                                    
                                    <div class="result-item">
                                        <label>Decoding Status:</label>
                                        <div class="result-value" id="decodingStatus"></div>
                                    </div>
                                </div>
                                
                                <div class="result-actions">
                                    <button class="btn btn-primary" onclick="downloadDecoded()">Download Result</button>
                                    <button class="btn btn-secondary" onclick="testEncode()">Test Encode</button>
                                </div>
                            </div>
                        </div>
                        
                        <!-- File Tab -->
                        <div id="file-tab" class="tab-pane">
                            <div class="input-group">
                                <label for="fileInput">Select File to Encode</label>
                                <input type="file" id="fileInput" accept="*/*">
                                <div class="file-info">
                                    <small>Maximum file size: 10MB. Supported formats: All file types</small>
                                </div>
                            </div>
                            
                            <div class="input-group">
                                <label for="fileOptions">File Encoding Options</label>
                                <div class="options-grid">
                                    <label class="checkbox-label">
                                        <input type="checkbox" id="fileUrlSafe" checked>
                                        URL Safe Encoding
                                    </label>
                                    <label class="checkbox-label">
                                        <input type="checkbox" id="fileCompress">
                                        Compress Before Encoding
                                    </label>
                                </div>
                            </div>
                            
                            <div class="button-group">
                                <button class="btn btn-primary" onclick="encodeFile()">Encode File</button>
                                <button class="btn btn-secondary" onclick="clearFile()">Clear</button>
                            </div>
                            
                            <div class="result" id="fileResult" style="display: none;">
                                <h3>File Encoding Result</h3>
                                <div class="result-display">
                                    <div class="result-item">
                                        <label>File Name:</label>
                                        <div class="result-value" id="fileName"></div>
                                    </div>
                                    
                                    <div class="result-item">
                                        <label>File Size:</label>
                                        <div class="result-value" id="fileSize"></div>
                                    </div>
                                    
                                    <div class="result-item">
                                        <label>Base64 Output:</label>
                                        <div class="result-value result-output" id="fileBase64Output">
                                            <span id="fileBase64Text"></span>
                                            <button class="copy-btn" onclick="copyResult('fileBase64Text')">📋 Copy</button>
                                        </div>
                                    </div>
                                    
                                    <div class="result-item">
                                        <label>Encoding Time:</label>
                                        <div class="result-value" id="encodingTime"></div>
                                    </div>
                                </div>
                                
                                <div class="result-actions">
                                    <button class="btn btn-primary" onclick="downloadFileResult()">Download Result</button>
                                    <button class="btn btn-secondary" onclick="previewFile()">Preview File</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Content Section -->
    <section class="content-section">
        <div class="container">
            <div class="content-grid">
                <article class="content-card">
                    <h2>What is Base64 Encoding?</h2>
                    <p>Base64 is a group of binary-to-text encoding schemes that represent binary data in an ASCII string format by translating it into a radix-64 representation. It's commonly used to encode binary data, such as images, files, or binary content, into a text format that can be safely transmitted over text-based protocols.</p>
                    
                    <p>For GoHighLevel users, understanding Base64 encoding is essential because:</p>
                    <ul>
                        <li><strong>API Integration:</strong> Many APIs require Base64 encoded data for secure transmission</li>
                        <li><strong>File Handling:</strong> Encode files for storage in databases or transmission via email</li>
                        <li><strong>Data Security:</strong> Safely transmit binary data through text-based channels</li>
                        <li><strong>Image Processing:</strong> Encode images for embedding in HTML or JSON</li>
                        <li><strong>Cross-Platform Compatibility:</strong> Ensure data integrity across different systems</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Why GoHighLevel Users Need This Tool</h2>
                    <p>As a GoHighLevel agency, you're constantly dealing with data integration, file handling, and API communications. Base64 encoding is a fundamental skill that enables you to handle various data types efficiently and securely.</p>
                    
                    <ul>
                        <li><strong>Client Data Integration:</strong> Handle various data formats from client systems</li>
                        <li><strong>API Development:</strong> Create and consume APIs that require Base64 encoding</li>
                        <li><strong>File Management:</strong> Encode files for storage and transmission</li>
                        <li><strong>Data Migration:</strong> Convert data between different formats and systems</li>
                        <li><strong>Technical Support:</strong> Help clients with data encoding issues</li>
                        <li><strong>System Integration:</strong> Connect different platforms and services</li>
                        <li><strong>Compliance Requirements:</strong> Meet data handling standards for various industries</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>How to Use the Base64 Encoder/Decoder</h2>
                    <p>Our Base64 tool is designed to provide comprehensive encoding and decoding capabilities with professional results:</p>
                    
                    <ol>
                        <li><strong>Choose Operation:</strong> Select between encoding, decoding, or file encoding</li>
                        <li><strong>Input Data:</strong> Enter text to encode or Base64 to decode</li>
                        <li><strong>Set Options:</strong> Configure encoding/decoding parameters</li>
                        <li><strong>Process Data:</strong> Click to perform the operation</li>
                        <li><strong>Review Results:</strong> Examine the output and metadata</li>
                        <li><strong>Copy or Download:</strong> Use the results as needed</li>
                        <li><strong>Test Operations:</strong> Verify encoding/decoding accuracy</li>
                    </ol>
                </article>

                <article class="content-card">
                    <h2>Use Cases for GoHighLevel Agencies</h2>
                    <p>This tool serves multiple purposes in your daily GoHighLevel operations:</p>
                    
                    <ul>
                        <li><strong>API Integration:</strong> Encode data for API requests and responses</li>
                        <li><strong>File Storage:</strong> Convert files to Base64 for database storage</li>
                        <li><strong>Email Attachments:</strong> Encode files for email transmission</li>
                        <li><strong>Webhook Processing:</strong> Handle Base64 encoded webhook data</li>
                        <li><strong>Data Migration:</strong> Convert data between different formats</li>
                        <li><strong>Client Support:</strong> Help clients with encoding/decoding tasks</li>
                        <li><strong>System Integration:</strong> Connect different platforms and services</li>
                        <li><strong>Testing and Debugging:</strong> Verify data encoding in development</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Base64 Encoding Applications</h2>
                    <p>Understanding these applications helps you choose the right encoding approach:</p>
                    
                    <ul>
                        <li><strong>Text Encoding:</strong> Convert plain text to Base64 for transmission</li>
                        <li><strong>Binary Data:</strong> Encode images, documents, and other binary files</li>
                        <li><strong>URL Encoding:</strong> Use URL-safe Base64 for web applications</li>
                        <li><strong>Email Encoding:</strong> Encode attachments for email transmission</li>
                        <li><strong>Database Storage:</strong> Store binary data in text-based databases</li>
                        <li><strong>API Communication:</strong> Transmit binary data via JSON APIs</li>
                        <li><strong>Configuration Files:</strong> Embed binary data in text configuration files</li>
                        <li><strong>Cross-Platform Data:</strong> Ensure data compatibility across systems</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Integration with GoHighLevel</h2>
                    <p>This tool integrates seamlessly with your GoHighLevel workflow:</p>
                    
                    <ul>
                        <li><strong>Client Onboarding:</strong> Handle various data formats during setup</li>
                        <li><strong>API Development:</strong> Create and consume APIs with Base64 data</li>
                        <li><strong>File Management:</strong> Process client files and documents</li>
                        <li><strong>Data Migration:</strong> Convert data between different systems</li>
                        <li><strong>System Integration:</strong> Connect GoHighLevel with other platforms</li>
                        <li><strong>Client Support:</strong> Help clients with data format issues</li>
                        <li><strong>Development Testing:</strong> Test encoding/decoding in development</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Base64 Best Practices</h2>
                    <p>Following these best practices ensures optimal results:</p>
                    
                    <ul>
                        <li><strong>URL Safety:</strong> Use URL-safe encoding for web applications</li>
                        <li><strong>Padding Handling:</strong> Consider whether padding is required</li>
                        <li><strong>Character Encoding:</strong> Ensure proper character encoding for text data</li>
                        <li><strong>File Size Limits:</strong> Be aware of size limitations for large files</li>
                        <li><strong>Error Handling:</strong> Implement proper error handling for invalid input</li>
                        <li><strong>Performance Considerations:</strong> Consider performance impact for large datasets</li>
                        <li><strong>Security Implications:</strong> Understand that Base64 is not encryption</li>
                        <li><strong>Validation:</strong> Validate Base64 input before decoding</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Advanced Base64 Strategies</h2>
                    <p>Beyond basic implementation, consider these advanced strategies:</p>
                    
                    <ul>
                        <li><strong>Streaming Processing:</strong> Handle large files in chunks</li>
                        <li><strong>Compression Integration:</strong> Compress data before encoding</li>
                        <li><strong>Batch Processing:</strong> Process multiple files simultaneously</li>
                        <li><strong>Custom Encoding Schemes:</strong> Implement modified Base64 variants</li>
                        <li><strong>Performance Optimization:</strong> Use efficient encoding algorithms</li>
                        <li><strong>Error Recovery:</strong> Implement robust error handling</li>
                        <li><strong>Memory Management:</strong> Optimize memory usage for large files</li>
                        <li><strong>Parallel Processing:</strong> Use multiple threads for encoding/decoding</li>
                    </ul>
                </article>
            </div>
        </div>
    </section>

    <!-- Related Tools -->
    <section class="related-tools">
        <div class="container">
            <h2>Related GoHighLevel Tools</h2>
            <div class="tools-grid">
                <a href="hash-generator.php" class="tool-link">
                    <div class="tool-icon">🔐</div>
                    <h3>Hash Generator</h3>
                    <p>Generate secure hashes for data verification and security</p>
                </a>
                <a href="json-formatter-validator.php" class="tool-link">
                    <div class="tool-icon">📊</div>
                    <h3>JSON Formatter & Validator</h3>
                    <p>Format and validate JSON data for your applications</p>
                </a>
                <a href="text-case-converter.php" class="tool-link">
                    <div class="tool-icon">🔤</div>
                    <h3>Text Case Converter</h3>
                    <p>Convert text between different case formats</p>
                </a>
            </div>
        </div>
    </section>

    <?php inc('includes/footer.php'); ?>
    <script src="common.js"></script>
    <script>`n    `n    // Load footer`n    fetch("footer.php")`n        .then(response => response.text())`n        .then(data => {`n            document.getElementById("footer-placeholder").innerHTML = data;`n        });`n});`n`n
        // Base64 Encoder/Decoder functionality
        let currentTab = 'encode';
        
        // Character counters
        document.getElementById('encodeInput').addEventListener('input', function() {
            const count = this.value.length;
            document.getElementById('encodeCharCounter').textContent = count;
        });
        
        document.getElementById('decodeInput').addEventListener('input', function() {
            const count = this.value.length;
            document.getElementById('decodeCharCounter').textContent = count;
        });
        
        function showTab(tabName) {
            // Hide all tab panes
            const tabPanes = document.querySelectorAll('.tab-pane');
            tabPanes.forEach(pane => pane.classList.remove('active'));
            
            // Remove active class from all tab buttons
            const tabButtons = document.querySelectorAll('.tab-btn');
            tabButtons.forEach(btn => btn.classList.remove('active'));
            
            // Show selected tab pane
            document.getElementById(tabName + '-tab').classList.add('active');
            
            // Add active class to selected tab button
            event.target.classList.add('active');
            
            currentTab = tabName;
        }
        
        function encodeText() {
            const input = document.getElementById('encodeInput').value.trim();
            const urlSafe = document.getElementById('encodeUrlSafe').checked;
            const includePadding = document.getElementById('encodePadding').checked;
            const handleNewlines = document.getElementById('encodeNewlines').checked;
            
            if (!input) {
                alert('Please enter some text to encode');
                return;
            }
            
            try {
                let textToEncode = input;
                
                // Handle newlines if requested
                if (handleNewlines) {
                    textToEncode = textToEncode.replace(/\n/g, '\\n');
                }
                
                // Encode to Base64
                let encoded = btoa(textToEncode);
                
                // Apply URL safe encoding if requested
                if (urlSafe) {
                    encoded = encoded.replace(/\+/g, '-').replace(/\//g, '_');
                }
                
                // Handle padding
                if (!includePadding) {
                    encoded = encoded.replace(/=/g, '');
                }
                
                displayEncodeResult(input, encoded);
                
            } catch (error) {
                console.error('Encoding error:', error);
                alert('Error encoding text. Please check your input.');
            }
        }
        
        function decodeText() {
            const input = document.getElementById('decodeInput').value.trim();
            const urlSafe = document.getElementById('decodeUrlSafe').checked;
            const strictMode = document.getElementById('decodeStrict').checked;
            const treatAsBinary = document.getElementById('decodeBinary').checked;
            
            if (!input) {
                alert('Please enter some Base64 text to decode');
                return;
            }
            
            try {
                let textToDecode = input;
                
                // Handle URL safe characters if requested
                if (urlSafe) {
                    textToDecode = textToDecode.replace(/-/g, '+').replace(/_/g, '/');
                }
                
                // Add padding if needed
                while (textToDecode.length % 4 !== 0) {
                    textToDecode += '=';
                }
                
                // Validate Base64 format if strict mode
                if (strictMode && !/^[A-Za-z0-9+/]*={0,2}$/.test(textToDecode)) {
                    throw new Error('Invalid Base64 format');
                }
                
                // Decode from Base64
                let decoded = atob(textToDecode);
                
                // Handle newlines
                decoded = decoded.replace(/\\n/g, '\n');
                
                displayDecodeResult(input, decoded, treatAsBinary);
                
            } catch (error) {
                console.error('Decoding error:', error);
                alert('Error decoding text. Please check your Base64 input.');
            }
        }
        
        function encodeFile() {
            const fileInput = document.getElementById('fileInput');
            const file = fileInput.files[0];
            const urlSafe = document.getElementById('fileUrlSafe').checked;
            const compress = document.getElementById('fileCompress').checked;
            
            if (!file) {
                alert('Please select a file to encode');
                return;
            }
            
            if (file.size > 10 * 1024 * 1024) { // 10MB limit
                alert('File size exceeds 10MB limit');
                return;
            }
            
            const startTime = performance.now();
            
            const reader = new FileReader();
            reader.onload = function(e) {
                try {
                    let data = e.target.result;
                    
                    // Compress if requested (simple compression for demo)
                    if (compress) {
                        data = data.toString().replace(/(.)\1+/g, '$1');
                    }
                    
                    // Encode to Base64
                    let encoded = btoa(data);
                    
                    // Apply URL safe encoding if requested
                    if (urlSafe) {
                        encoded = encoded.replace(/\+/g, '-').replace(/\//g, '_');
                    }
                    
                    const endTime = performance.now();
                    const encodingTime = ((endTime - startTime) / 1000).toFixed(3);
                    
                    displayFileResult(file, encoded, encodingTime);
                    
                } catch (error) {
                    console.error('File encoding error:', error);
                    alert('Error encoding file. Please try again.');
                }
            };
            
            reader.readAsBinaryString(file);
        }
        
        function displayEncodeResult(original, encoded) {
            document.getElementById('originalText').textContent = original;
            document.getElementById('base64Text').textContent = encoded;
            document.getElementById('outputLength').textContent = encoded.length + ' characters';
            
            const ratio = ((encoded.length / original.length) * 100).toFixed(1);
            document.getElementById('encodingRatio').textContent = ratio + '% of original size';
            
            document.getElementById('encodeResult').style.display = 'block';
        }
        
        function displayDecodeResult(base64Input, decoded, isBinary) {
            document.getElementById('base64Input').textContent = base64Input;
            document.getElementById('decodedTextContent').textContent = decoded;
            document.getElementById('dataType').textContent = isBinary ? 'Binary Data' : 'Text Data';
            document.getElementById('decodingStatus').textContent = 'Successfully decoded';
            
            document.getElementById('decodeResult').style.display = 'block';
        }
        
        function displayFileResult(file, encoded, encodingTime) {
            document.getElementById('fileName').textContent = file.name;
            document.getElementById('fileSize').textContent = formatFileSize(file.size);
            document.getElementById('fileBase64Text').textContent = encoded;
            document.getElementById('encodingTime').textContent = encodingTime + ' seconds';
            
            document.getElementById('fileResult').style.display = 'block';
        }
        
        function formatFileSize(bytes) {
            if (bytes === 0) return '0 Bytes';
            const k = 1024;
            const sizes = ['Bytes', 'KB', 'MB', 'GB'];
            const i = Math.floor(Math.log(bytes) / Math.log(k));
            return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + ' ' + sizes[i];
        }
        
        function clearEncode() {
            document.getElementById('encodeInput').value = '';
            document.getElementById('encodeResult').style.display = 'none';
            document.getElementById('encodeCharCounter').textContent = '0';
        }
        
        function clearDecode() {
            document.getElementById('decodeInput').value = '';
            document.getElementById('decodeResult').style.display = 'none';
            document.getElementById('decodeCharCounter').textContent = '0';
        }
        
        function clearFile() {
            document.getElementById('fileInput').value = '';
            document.getElementById('fileResult').style.display = 'none';
        }
        
        function copyResult(elementId) {
            const text = document.getElementById(elementId).textContent;
            navigator.clipboard.writeText(text).then(() => {
                alert('Result copied to clipboard!');
            }).catch(err => {
                console.error('Failed to copy: ', err);
                // Fallback for older browsers
                const textArea = document.createElement('textarea');
                textArea.value = text;
                document.body.appendChild(textArea);
                textArea.select();
                document.execCommand('copy');
                document.body.removeChild(textArea);
                alert('Result copied to clipboard!');
            });
        }
        
        function downloadEncoded() {
            const original = document.getElementById('encodeInput').value.trim();
            const encoded = document.getElementById('base64Text').textContent;
            
            const data = {
                original: original,
                encoded: encoded,
                timestamp: new Date().toISOString(),
                operation: 'encode'
            };
            
            const dataStr = JSON.stringify(data, null, 2);
            const dataBlob = new Blob([dataStr], {type: 'application/json'});
            
            const link = document.createElement('a');
            link.href = URL.createObjectURL(dataBlob);
            link.download = 'base64-encoded-result.json';
            link.click();
        }
        
        function downloadDecoded() {
            const base64Input = document.getElementById('decodeInput').value.trim();
            const decoded = document.getElementById('decodedTextContent').textContent;
            
            const data = {
                base64Input: base64Input,
                decoded: decoded,
                timestamp: new Date().toISOString(),
                operation: 'decode'
            };
            
            const dataStr = JSON.stringify(data, null, 2);
            const dataBlob = new Blob([dataStr], {type: 'application/json'});
            
            const link = document.createElement('a');
            link.href = URL.createObjectURL(dataBlob);
            link.download = 'base64-decoded-result.json';
            link.click();
        }
        
        function downloadFileResult() {
            const fileName = document.getElementById('fileName').textContent;
            const encoded = document.getElementById('fileBase64Text').textContent;
            
            const data = {
                fileName: fileName,
                encoded: encoded,
                timestamp: new Date().toISOString(),
                operation: 'file-encode'
            };
            
            const dataStr = JSON.stringify(data, null, 2);
            const dataBlob = new Blob([dataStr], {type: 'application/json'});
            
            const link = document.createElement('a');
            link.href = URL.createObjectURL(dataBlob);
            link.download = 'base64-file-result.json';
            link.click();
        }
        
        function testDecode() {
            const encoded = document.getElementById('base64Text').textContent;
            if (encoded) {
                document.getElementById('decodeInput').value = encoded;
                showTab('decode');
                decodeText();
            }
        }
        
        function testEncode() {
            const decoded = document.getElementById('decodedTextContent').textContent;
            if (decoded) {
                document.getElementById('encodeInput').value = decoded;
                showTab('encode');
                encodeText();
            }
        }
        
        function previewFile() {
            const encoded = document.getElementById('fileBase64Text').textContent;
            if (encoded) {
                try {
                    // Convert Base64 back to binary
                    const binaryString = atob(encoded);
                    const bytes = new Uint8Array(binaryString.length);
                    for (let i = 0; i < binaryString.length; i++) {
                        bytes[i] = binaryString.charCodeAt(i);
                    }
                    
                    // Create blob and preview
                    const blob = new Blob([bytes]);
                    const url = URL.createObjectURL(blob);
                    
                    // Open in new window/tab
                    window.open(url, '_blank');
                    
                } catch (error) {
                    console.error('File preview error:', error);
                    alert('Unable to preview file. Please download and open manually.');
                }
            }
        }
    </script>

    <style>
        .encoding-tabs {
            display: flex;
            border-bottom: 2px solid #e9ecef;
            margin-bottom: 20px;
        }
        
        .tab-btn {
            background: none;
            border: none;
            padding: 10px 20px;
            cursor: pointer;
            border-bottom: 2px solid transparent;
            transition: all 0.3s ease;
        }
        
        .tab-btn.active {
            border-bottom-color: #007bff;
            color: #007bff;
            font-weight: 600;
        }
        
        .tab-btn:hover {
            background-color: #f8f9fa;
        }
        
        .tab-pane {
            display: none;
        }
        
        .tab-pane.active {
            display: block;
        }
        
        .char-counter {
            font-size: 12px;
            color: #666;
            text-align: right;
            margin-top: 5px;
        }
        
        .options-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin-top: 10px;
        }
        
        .checkbox-label {
            display: flex;
            align-items: center;
            gap: 8px;
            cursor: pointer;
            font-size: 14px;
        }
        
        .checkbox-label input[type="checkbox"] {
            margin: 0;
        }
        
        .file-info {
            font-size: 12px;
            color: #666;
            margin-top: 5px;
            font-style: italic;
        }
        
        .result-display {
            background: #f8f9fa;
            border: 1px solid #e9ecef;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        
        .result-item {
            display: flex;
            align-items: center;
            margin-bottom: 15px;
            padding: 10px;
            background: white;
            border-radius: 6px;
            border: 1px solid #e9ecef;
        }
        
        .result-item label {
            font-weight: 600;
            min-width: 120px;
            color: #333;
        }
        
        .result-value {
            flex: 1;
            font-family: 'Courier New', monospace;
            background: #f8f9fa;
            padding: 8px 12px;
            border-radius: 4px;
            border: 1px solid #dee2e6;
            word-break: break-all;
            max-height: 200px;
            overflow-y: auto;
        }
        
        .result-output {
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 10px;
        }
        
        .copy-btn {
            background: #007bff;
            color: white;
            border: none;
            padding: 4px 8px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 12px;
            white-space: nowrap;
        }
        
        .copy-btn:hover {
            background: #0056b3;
        }
        
        .result-actions {
            margin-top: 20px;
            text-align: center;
        }
        
        .result-actions .btn {
            margin: 0 10px;
        }
        
        @media (max-width: 768px) {
            .options-grid {
                grid-template-columns: 1fr;
            }
            
            .result-item {
                flex-direction: column;
                align-items: flex-start;
            }
            
            .result-item label {
                min-width: auto;
                margin-bottom: 5px;
            }
            
            .encoding-tabs {
                flex-direction: column;
            }
            
            .tab-btn {
                text-align: left;
                border-bottom: none;
                border-left: 3px solid transparent;
            }
            
            .tab-btn.active {
                border-left-color: #007bff;
                border-bottom-color: transparent;
            }
        }
    </style>
</body>
</html>




